/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.jenvtest;

import io.javaoperatorsdk.jenvtest.CertManager;
import io.javaoperatorsdk.jenvtest.JenvtestException;
import io.javaoperatorsdk.jenvtest.binary.BinaryManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubeConfig {
    private static final Logger log = LoggerFactory.getLogger(KubeConfig.class);
    public static final String JENVTEST = "jenvtest";
    private CertManager certManager;
    private BinaryManager binaryManager;

    public KubeConfig(CertManager certManager, BinaryManager binaryManager) {
        this.certManager = certManager;
        this.binaryManager = binaryManager;
    }

    public void updateKubeConfig(int apiServerPort) {
        log.debug("Updating kubeconfig");
        this.execWithKubectlConfigAndWait("set-cluster", JENVTEST, "--server=https://127.0.0.1:" + apiServerPort, "--certificate-authority=" + this.certManager.getAPIServerCertPath());
        this.execWithKubectlConfigAndWait("set-credentials", JENVTEST, "--client-certificate=" + this.certManager.getClientCertPath(), "--client-key=" + this.certManager.getClientKeyPath());
        this.execWithKubectlConfigAndWait("set-context", JENVTEST, "--cluster=jenvtest", "--namespace=default", "--user=jenvtest");
        this.execWithKubectlConfigAndWait("use-context", JENVTEST);
    }

    public void cleanupFromKubeConfig() {
        log.debug("Cleanig up kubeconfig");
        this.unset("contexts.jenvtest");
        this.unset("clusters.jenvtest");
        this.unset("users.jenvtest");
        this.unset("current-context");
    }

    private void unset(String target) {
        this.execWithKubectlConfigAndWait("unset", target);
    }

    private void execWithKubectlConfigAndWait(String ... arguments) {
        try {
            ArrayList<String> args = new ArrayList<String>(arguments.length + 2);
            args.add(this.binaryManager.binaries().getKubectl().getPath());
            args.add("config");
            args.addAll(List.of(arguments));
            Process process = new ProcessBuilder(args).start();
            process.waitFor();
        }
        catch (IOException e) {
            throw new JenvtestException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new JenvtestException(e);
        }
    }
}

