/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.jenvtest;

import io.javaoperatorsdk.jenvtest.JenvtestException;
import io.javaoperatorsdk.jenvtest.KubeAPIServerConfig;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public final class KubeAPIServerConfigBuilder {
    public static final String JENVTEST_DOWNLOAD_BINARIES = "JENVTEST_DOWNLOAD_BINARIES";
    public static final String JENVTEST_DIR_ENV_VAR = "JENVTEST_DIR";
    public static final String JENVTEST_API_SERVER_VERSION_ENV_VAR = "JENVTEST_API_SERVER_VERSION";
    public static final String DIRECTORY_NAME = ".jenvtest";
    private String jenvtestDir;
    private String apiServerVersion;
    private Boolean offlineMode;
    private final List<String> apiServerFlags = new ArrayList<String>(0);

    public static KubeAPIServerConfigBuilder anAPIServerConfig() {
        return new KubeAPIServerConfigBuilder();
    }

    public KubeAPIServerConfigBuilder withJenvtestDir(String jenvtestDir) {
        this.jenvtestDir = jenvtestDir;
        return this;
    }

    public KubeAPIServerConfigBuilder withApiServerVersion(String apiServerVersion) {
        this.apiServerVersion = apiServerVersion;
        return this;
    }

    public KubeAPIServerConfigBuilder withOfflineMode(boolean downloadBinaries) {
        this.offlineMode = downloadBinaries;
        return this;
    }

    public KubeAPIServerConfig build() {
        String apiServerVersionEnvVar;
        if (this.jenvtestDir == null) {
            String jenvtestDirFromEnvVar = System.getenv(JENVTEST_DIR_ENV_VAR);
            this.jenvtestDir = jenvtestDirFromEnvVar != null ? jenvtestDirFromEnvVar : new File(System.getProperty("user.home"), DIRECTORY_NAME).getPath();
        }
        if (this.offlineMode == null) {
            String downloadBinariesEnvVal = System.getenv(JENVTEST_DOWNLOAD_BINARIES);
            this.offlineMode = downloadBinariesEnvVal != null ? Boolean.valueOf(Boolean.parseBoolean(downloadBinariesEnvVal)) : Boolean.valueOf(false);
        }
        if (this.apiServerVersion == null && (apiServerVersionEnvVar = System.getenv(JENVTEST_API_SERVER_VERSION_ENV_VAR)) != null) {
            this.apiServerVersion = apiServerVersionEnvVar;
        }
        return new KubeAPIServerConfig(this.jenvtestDir, this.apiServerVersion, this.offlineMode, this.apiServerFlags);
    }

    public void withApiServerFlags(List<String> flags) {
        this.apiServerFlags.addAll(flags);
    }

    public void withApiServerFlag(String key, String value) {
        this.checkKeyPrefix(key);
        this.apiServerFlags.add(key);
        this.apiServerFlags.add(value);
    }

    public void withApiServerFlag(String key) {
        this.checkKeyPrefix(key);
        this.apiServerFlags.add(key);
    }

    private void checkKeyPrefix(String key) {
        if (!key.startsWith("--")) {
            throw new JenvtestException("Kube API Server flag needs to start with double dash: '--'; Instead found key: " + key);
        }
    }
}

