/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.jenvtest;

import io.javaoperatorsdk.jenvtest.CertManager;
import io.javaoperatorsdk.jenvtest.KubeAPIServerConfig;
import io.javaoperatorsdk.jenvtest.KubeAPIServerConfigBuilder;
import io.javaoperatorsdk.jenvtest.KubeConfig;
import io.javaoperatorsdk.jenvtest.binary.BinaryManager;
import io.javaoperatorsdk.jenvtest.process.EtcdProcess;
import io.javaoperatorsdk.jenvtest.process.KubeAPIServerProcess;
import io.javaoperatorsdk.jenvtest.process.UnexpectedProcessStopHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubeAPIServer
implements UnexpectedProcessStopHandler {
    private static final Logger log = LoggerFactory.getLogger(KubeAPIServer.class);
    public static final int STARTUP_TIMEOUT = 15000;
    private final KubeAPIServerConfig config;
    private final BinaryManager binaryManager;
    private final CertManager certManager;
    private final KubeConfig kubeConfig;
    private final EtcdProcess etcdProcess;
    private final KubeAPIServerProcess kubeApiServerProcess;

    public KubeAPIServer() {
        this(KubeAPIServerConfigBuilder.anAPIServerConfig().build());
    }

    public KubeAPIServer(KubeAPIServerConfig config) {
        this.config = config;
        this.binaryManager = new BinaryManager(config);
        this.certManager = new CertManager(config.getJenvtestDir());
        this.kubeConfig = new KubeConfig(this.certManager, this.binaryManager);
        this.etcdProcess = new EtcdProcess(this.binaryManager, this);
        this.kubeApiServerProcess = new KubeAPIServerProcess(this.certManager, this.binaryManager, this, config);
    }

    public void start() {
        log.debug("Stating API Server. Using jenvtest dir: {}", (Object)this.config.getJenvtestDir());
        this.binaryManager.initAndDownloadIfRequired();
        this.certManager.createCertificatesIfNeeded();
        this.etcdProcess.cleanEtcdData();
        int etcdPort = this.etcdProcess.startEtcd();
        int apiServerPort = this.kubeApiServerProcess.startApiServer(etcdPort);
        this.kubeConfig.updateKubeConfig(apiServerPort);
        this.kubeApiServerProcess.waitUntilDefaultNamespaceCreated();
        log.debug("API Server ready to use");
    }

    public void stop() {
        log.debug("Stopping");
        this.kubeApiServerProcess.stopApiServer();
        this.etcdProcess.stopEtcd();
        this.kubeConfig.cleanupFromKubeConfig();
        this.etcdProcess.cleanEtcdData();
        log.debug("Stopped");
    }

    @Override
    public void processStopped(Process process) {
        this.stop();
    }
}

