/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.jenvtest.junit;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.javaoperatorsdk.jenvtest.JenvtestException;
import io.javaoperatorsdk.jenvtest.KubeAPIServer;
import io.javaoperatorsdk.jenvtest.junit.ClientInjectionHandler;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.junit.jupiter.api.extension.ExtensionContext;

public class Fabric8ClientInjectionHandler
implements ClientInjectionHandler {
    public boolean isTargetFieldAvailable(ExtensionContext extensionContext, boolean staticField) {
        return Fabric8ClientInjectionHandler.getFieldForKubeConfigInjection(extensionContext, staticField).isPresent();
    }

    public void inject(ExtensionContext extensionContext, boolean staticField, KubeAPIServer kubeApiServer) {
        Field field = Fabric8ClientInjectionHandler.getFieldForKubeConfigInjection(extensionContext, staticField).orElseThrow();
        this.setKubeConfigYamlToField(extensionContext, field, kubeApiServer);
    }

    private void setKubeConfigYamlToField(ExtensionContext extensionContext, Field kubeConfigField, KubeAPIServer kubeApiServer) {
        try {
            Object target = extensionContext.getTestInstance().orElseGet(() -> extensionContext.getTestClass().orElseThrow());
            kubeConfigField.setAccessible(true);
            kubeConfigField.set(target, new KubernetesClientBuilder().withConfig(Config.fromKubeconfig((String)kubeApiServer.getKubeConfigYaml())).build());
        }
        catch (IllegalAccessException e) {
            throw new JenvtestException((Throwable)e);
        }
    }

    public static Optional<Field> getFieldForKubeConfigInjection(ExtensionContext extensionContext, boolean staticField) {
        Class clazz = (Class)extensionContext.getTestClass().orElseThrow();
        List kubeConfigFields = Arrays.stream(clazz.getDeclaredFields()).filter(f -> KubernetesClient.class.isAssignableFrom(f.getType())).collect(Collectors.toList());
        if (kubeConfigFields.isEmpty()) {
            return Optional.empty();
        }
        if (kubeConfigFields.size() > 1) {
            throw new JenvtestException("More fields type KubernetesClient found");
        }
        Field field = (Field)kubeConfigFields.get(0);
        if (Modifier.isStatic(field.getModifiers()) != staticField) {
            return Optional.empty();
        }
        return Optional.of(field);
    }
}

