/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.processing.event.source.cache;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.javaoperatorsdk.operator.processing.event.source.cache.BoundedItemStore;
import io.javaoperatorsdk.operator.processing.event.source.cache.CaffeineBoundedCache;
import java.time.Duration;

public class CaffeineBoundedItemStores {
    private CaffeineBoundedItemStores() {
    }

    public static <R extends HasMetadata> BoundedItemStore<R> boundedItemStore(KubernetesClient client, Class<R> rClass, Duration accessExpireDuration) {
        Cache cache = Caffeine.newBuilder().expireAfterAccess(accessExpireDuration).build();
        return CaffeineBoundedItemStores.boundedItemStore(client, rClass, cache);
    }

    public static <R extends HasMetadata> BoundedItemStore<R> boundedItemStore(KubernetesClient client, Class<R> rClass, Cache<String, R> cache) {
        return new BoundedItemStore(new CaffeineBoundedCache<String, R>(cache), rClass, client);
    }
}

