/**
 * $Id$
 * 
 * SARL is an general-purpose agent programming language.
 * More details on http://www.sarl.io
 * 
 * Copyright (C) 2014-2020 the original authors or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.sarl.sre.boot.internal.cli;

import com.google.inject.AbstractModule;
import io.bootique.BQCoreModule;
import io.bootique.BQCoreModuleExtender;
import io.sarl.lang.SARLVersion;
import io.sarl.lang.annotation.SarlElementType;
import io.sarl.lang.annotation.SarlSpecification;
import io.sarl.lang.annotation.SyntheticMember;
import io.sarl.maven.bootiqueapp.utils.SystemProperties;
import io.sarl.sre.boot.commands.RunSingleAgentCommand;
import io.sarl.sre.boot.configs.SreConfig;
import io.sarl.sre.boot.internal.cli.Messages;
import java.text.MessageFormat;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.arakhne.afc.bootique.applicationdata2.annotations.DefaultApplicationName;
import org.arakhne.afc.bootique.synopsishelp.annotations.ApplicationArgumentSynopsis;
import org.arakhne.afc.bootique.synopsishelp.annotations.ApplicationDetailedDescription;

/**
 * Module for configuring the janus application information.
 * 
 * @author $Author: sgalland$
 * @version $FullVersion$
 * @mavengroupid $GroupId$
 * @mavenartifactid $ArtifactId$
 * @since 3.0.11.0
 */
@SarlSpecification("0.11")
@SarlElementType(10)
@SuppressWarnings("all")
public class JanusApplicationModule extends AbstractModule {
  /**
   * Provider of the long description of the application.
   * 
   * @author $Author: sgalland$
   * @version $FullVersion$
   * @mavengroupid $GroupId$
   * @mavenartifactid $ArtifactId$
   * @since 3.0.11.0
   */
  @SarlSpecification("0.11")
  @SarlElementType(10)
  private static class LongDescriptionProvider implements Provider<String> {
    @Override
    public String get() {
      final String implementationJavaVersion = SARLVersion.MINIMAL_JDK_VERSION_FOR_SARL_COMPILATION_ENVIRONMENT;
      return MessageFormat.format(Messages.JanusApplicationModule_2, implementationJavaVersion);
    }
    
    @SyntheticMember
    public LongDescriptionProvider() {
      super();
    }
  }
  
  @Override
  protected void configure() {
    this.<String>bind(String.class).annotatedWith(DefaultApplicationName.class).toInstance(
      SystemProperties.getValue((SreConfig.PREFIX + ".programName"), SreConfig.DEFAULT_PROGRAM_NAME));
    BQCoreModuleExtender _extend = BQCoreModule.extend(this.binder());
    _extend.setApplicationDescription(Messages.JanusApplicationModule_0);
    this.<String>bind(String.class).annotatedWith(ApplicationDetailedDescription.class).toProvider(JanusApplicationModule.LongDescriptionProvider.class).in(Singleton.class);
    this.<String>bind(String.class).annotatedWith(ApplicationArgumentSynopsis.class).toInstance(Messages.JanusApplicationModule_1);
    BQCoreModuleExtender _extend_1 = BQCoreModule.extend(this.binder());
    _extend_1.setDefaultCommand(RunSingleAgentCommand.class);
  }
  
  @SyntheticMember
  public JanusApplicationModule() {
    super();
  }
}
