/*
 * Decompiled with CFR 0.152.
 */
package org.arakhne.afc.vmutil.resource;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.arakhne.afc.vmutil.ResourceNotFoundException;
import org.arakhne.afc.vmutil.Resources;
import org.arakhne.afc.vmutil.asserts.AssertMessages;

class URLConnection
extends java.net.URLConnection {
    private URL location;
    private java.net.URLConnection connection;

    protected URLConnection(URL url) {
        super(url);
    }

    @Override
    public String getHeaderField(int index) {
        assert (index >= 0) : AssertMessages.positiveOrZeroParameter();
        try {
            this.connect();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return this.connection.getHeaderField(index);
    }

    @Override
    public String getHeaderField(String name) {
        try {
            this.connect();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return this.connection.getHeaderField(name);
    }

    @Override
    public String getHeaderFieldKey(int index) {
        assert (index >= 0) : AssertMessages.positiveOrZeroParameter();
        try {
            this.connect();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return this.connection.getHeaderFieldKey(index);
    }

    @Override
    public Map<String, List<String>> getHeaderFields() {
        try {
            this.connect();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return this.connection.getHeaderFields();
    }

    @Override
    public void connect() throws IOException {
        if (!this.connected) {
            this.location = Resources.getResource(this.url.getFile());
            if (this.location == null) {
                throw new ResourceNotFoundException(this.url.toExternalForm());
            }
            this.connection = this.location.openConnection();
            if (this.connection == null) {
                throw new ResourceNotFoundException(this.url.toExternalForm());
            }
            this.connection.setDoInput(this.getDoInput());
            this.connection.setDoOutput(this.getDoOutput());
            this.connection.setAllowUserInteraction(this.getAllowUserInteraction());
            this.connection.setConnectTimeout(this.getConnectTimeout());
            this.connection.setDefaultUseCaches(this.getDefaultUseCaches());
            this.connection.setReadTimeout(this.getReadTimeout());
            this.connection.setIfModifiedSince(this.getIfModifiedSince());
            this.connected = true;
        }
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        this.connect();
        return this.connection.getOutputStream();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        this.connect();
        return this.connection.getInputStream();
    }
}

