/*
 * Decompiled with CFR 0.152.
 */
package org.arakhne.afc.vmutil;

import java.net.URI;
import java.net.URL;
import org.arakhne.afc.vmutil.URLHandlerUtil;
import org.eclipse.xtext.xbase.lib.Pure;

public enum URISchemeType {
    HTTP{

        @Override
        public boolean isFileBasedScheme() {
            return true;
        }
    }
    ,
    HTTPS{

        @Override
        public boolean isFileBasedScheme() {
            return true;
        }
    }
    ,
    FTP{

        @Override
        public boolean isFileBasedScheme() {
            return true;
        }
    }
    ,
    FILE{

        @Override
        public boolean isFileBasedScheme() {
            return true;
        }
    }
    ,
    MAILTO{

        @Override
        public boolean isFileBasedScheme() {
            return false;
        }
    }
    ,
    NEWS{

        @Override
        public boolean isFileBasedScheme() {
            return false;
        }
    }
    ,
    TELNET{

        @Override
        public boolean isFileBasedScheme() {
            return false;
        }
    }
    ,
    SSH{

        @Override
        public boolean isFileBasedScheme() {
            return true;
        }
    }
    ,
    JAR{

        @Override
        public boolean isFileBasedScheme() {
            return true;
        }
    }
    ,
    RESOURCE{

        @Override
        public boolean isFileBasedScheme() {
            return true;
        }
    }
    ,
    UNSUPPORTED{

        @Override
        public boolean isFileBasedScheme() {
            return false;
        }
    };


    static {
        URLHandlerUtil.installArakhneHandlers();
    }

    private URISchemeType() {
    }

    @Pure
    public String toString() {
        return String.valueOf(this.name().toLowerCase()) + ":";
    }

    @Pure
    public boolean isURL(URL url) {
        return URISchemeType.getSchemeType(url) == this;
    }

    public boolean isURI(URI uri) {
        return URISchemeType.getSchemeType(uri) == this;
    }

    @Pure
    public boolean isScheme(String string) {
        return URISchemeType.getSchemeType(string) == this;
    }

    @Pure
    public String removeScheme(String string) {
        int idx;
        if (string != null && (idx = string.indexOf(58)) >= 0) {
            String result = string.substring(0, idx + 1);
            if (this.toString().equalsIgnoreCase(result)) {
                result = string.substring(idx + 1);
                if (result.startsWith("//")) {
                    return result.substring(2);
                }
                return result;
            }
        }
        return string;
    }

    @Pure
    public static String removeAnyScheme(String string) {
        int idx;
        if (string != null && (idx = string.indexOf(58)) >= 0) {
            String result = string.substring(0, idx + 1);
            URISchemeType[] uRISchemeTypeArray = URISchemeType.values();
            int n = uRISchemeTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                URISchemeType type = uRISchemeTypeArray[n2];
                if (type.toString().equalsIgnoreCase(result)) {
                    result = string.substring(idx + 1);
                    if (result.startsWith("//")) {
                        return result.substring(2);
                    }
                    return result;
                }
                ++n2;
            }
        }
        return string;
    }

    private static URISchemeType getSchemeType(String protocol) {
        String proto = protocol;
        int idx = protocol.indexOf(58);
        if (idx >= 0) {
            proto = protocol.substring(0, idx);
        }
        if (proto == null || "".equals(protocol) || "file".equalsIgnoreCase(proto)) {
            return FILE;
        }
        if ("http".equalsIgnoreCase(proto)) {
            return HTTP;
        }
        if ("https".equalsIgnoreCase(proto)) {
            return HTTPS;
        }
        if ("ftp".equalsIgnoreCase(proto)) {
            return FTP;
        }
        if ("mailto".equalsIgnoreCase(proto)) {
            return MAILTO;
        }
        if ("news".equalsIgnoreCase(proto)) {
            return NEWS;
        }
        if ("ssh".equalsIgnoreCase(proto) || "sftp".equalsIgnoreCase(proto)) {
            return SSH;
        }
        if ("telnet".equalsIgnoreCase(proto)) {
            return TELNET;
        }
        if ("jar".equalsIgnoreCase(proto)) {
            return JAR;
        }
        if ("resource".equalsIgnoreCase(proto)) {
            return RESOURCE;
        }
        return UNSUPPORTED;
    }

    @Pure
    public static URISchemeType getSchemeType(URL url) {
        if (url != null) {
            return URISchemeType.getSchemeType(url.getProtocol());
        }
        return UNSUPPORTED;
    }

    @Pure
    public static URISchemeType getSchemeType(URI uri) {
        if (uri != null) {
            return URISchemeType.getSchemeType(uri.getScheme());
        }
        return UNSUPPORTED;
    }

    @Pure
    public abstract boolean isFileBasedScheme();

    /* synthetic */ URISchemeType(String string, int n, URISchemeType uRISchemeType) {
        this();
    }
}

