/*
 * Decompiled with CFR 0.152.
 */
package org.arakhne.afc.vmutil;

import java.io.InputStream;
import java.net.URL;
import org.arakhne.afc.vmutil.ClassLoaderFinder;
import org.arakhne.afc.vmutil.ResourceWrapper;
import org.arakhne.afc.vmutil.Resources;
import org.eclipse.xtext.xbase.lib.Pure;

class StandardJREResourceWrapper
implements ResourceWrapper {
    public static final String RESOURCE_PREFIX = "resources/";

    StandardJREResourceWrapper() {
    }

    @Override
    @Pure
    public URL getResource(ClassLoader classLoader, String path) {
        ClassLoader loader;
        if (path == null) {
            return null;
        }
        String resourcePath = path;
        if (path.startsWith("/")) {
            resourcePath = path.substring(1);
        }
        ClassLoader classLoader2 = loader = classLoader == null ? ClassLoaderFinder.findClassLoader() : classLoader;
        assert (loader != null);
        URL url = loader.getResource(resourcePath);
        if (url == null) {
            url = loader.getResource(RESOURCE_PREFIX + resourcePath);
        }
        return url;
    }

    @Override
    @Pure
    public InputStream getResourceAsStream(ClassLoader classLoader, String path) {
        ClassLoader loader;
        if (path == null) {
            return null;
        }
        String resourcePath = path;
        if (path.startsWith("/")) {
            resourcePath = path.substring(1);
        }
        if ((loader = classLoader) == null) {
            loader = ClassLoaderFinder.findClassLoader();
        }
        if (loader == null) {
            loader = Resources.class.getClassLoader();
        }
        assert (loader != null);
        InputStream is = loader.getResourceAsStream(resourcePath);
        if (is == null) {
            is = loader.getResourceAsStream(RESOURCE_PREFIX + resourcePath);
        }
        return is;
    }

    @Override
    @Pure
    public String translateResourceName(String resourceName) {
        return resourceName;
    }
}

