/*
 * Decompiled with CFR 0.152.
 */
package org.arakhne.afc.vmutil;

import java.io.File;
import org.arakhne.afc.vmutil.AbstractOperatingSystemWrapper;
import org.arakhne.afc.vmutil.OperatingSystemIdentificationType;

class OperatingSystemUDevWrapper
extends AbstractOperatingSystemWrapper {
    OperatingSystemUDevWrapper() {
    }

    private static String runUdev(File file, String key) {
        String result = OperatingSystemUDevWrapper.runCommand("udevadm", "info", "-q", "property", "-n", file.toString());
        return OperatingSystemUDevWrapper.cut("=", 1, OperatingSystemUDevWrapper.grep(String.valueOf(key) + "=", result));
    }

    @Override
    public String getOSSerialNumber(boolean enableSuperUser, boolean enableGUI) {
        File file = new File("/dev/sda");
        if (file.exists()) {
            return OperatingSystemUDevWrapper.runUdev(file, "ID_SERIAL");
        }
        file = new File("/dev/hda");
        if (file.exists()) {
            return OperatingSystemUDevWrapper.runUdev(file, "ID_SERIAL");
        }
        return null;
    }

    @Override
    public String getOSUUID(boolean enableSuperUser, boolean enableGUI) {
        File file = new File("/dev/sda");
        if (file.exists()) {
            return OperatingSystemUDevWrapper.runUdev(file, "ID_SERIAL_SHORT");
        }
        file = new File("/dev/hda");
        if (file.exists()) {
            return OperatingSystemUDevWrapper.runUdev(file, "ID_SERIAL_SHORT");
        }
        return null;
    }

    @Override
    public OperatingSystemIdentificationType getIdentificationType() {
        return OperatingSystemIdentificationType.HARD_DISK;
    }
}

