/*
 * Decompiled with CFR 0.152.
 */
package org.arakhne.afc.vmutil;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.UUID;
import org.arakhne.afc.vmutil.AbstractOperatingSystemWrapper;
import org.arakhne.afc.vmutil.Android;
import org.arakhne.afc.vmutil.OperatingSystemIdentificationType;

class OperatingSystemAndroidWrapper
extends AbstractOperatingSystemWrapper {
    private static final String PREFS_FILE = "device_id.xml";
    private static final String PREFS_DEVICE_ID = "device_id";

    OperatingSystemAndroidWrapper() {
    }

    private static Object getPreferences(Object context) {
        assert (context != null);
        try {
            Method method = context.getClass().getMethod("getSharedPreferences", String.class, Integer.TYPE);
            Object prefs = method.invoke(context, PREFS_FILE, 0);
            assert (prefs != null);
            return prefs;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static String getSerialFromPreferences(Object prefs) {
        try {
            Method method = prefs.getClass().getMethod("getString", String.class, String.class);
            Object v = method.invoke(prefs, PREFS_DEVICE_ID, null);
            String label = Objects.toString(v, null);
            if (label != null && !label.isEmpty()) {
                return label;
            }
        }
        catch (Exception exception) {}
        return null;
    }

    private static String getAndroidID() {
        try {
            Class<?> secureClass = Android.getSecureSettingsClass();
            Method getStringMethod = secureClass.getMethod("getString", Android.getContextResolverClass(), String.class);
            Field androidIdField = secureClass.getField("ANDROID_ID");
            Object androidId = androidIdField.get(null);
            Object v = getStringMethod.invoke(null, Android.getContextResolver(), androidId);
            String label = Objects.toString(v, null);
            if (label != null && !label.isEmpty() && !"9774d56d682e549c".equalsIgnoreCase(label)) {
                return label;
            }
        }
        catch (Exception exception) {}
        return null;
    }

    private static String getDeviceID(Object context) {
        try {
            Object v;
            String label;
            Class<?> contextClass = context.getClass();
            Method method = contextClass.getMethod("getSystemService", String.class);
            Field field = contextClass.getField("TELEPHONY_SERVICE");
            Object telephonyManager = method.invoke(context, field.get(null));
            if (telephonyManager != null && (label = Objects.toString(v = (method = telephonyManager.getClass().getMethod("getDeviceId", new Class[0])).invoke(telephonyManager, new Object[0]), null)) != null && !label.isEmpty()) {
                return label;
            }
        }
        catch (Exception exception) {}
        return null;
    }

    private static String randomID(Object prefs) {
        try {
            String serial = UUID.randomUUID().toString();
            Method method = prefs.getClass().getMethod("edit", new Class[0]);
            Object v = method.invoke(prefs, new Object[0]);
            method = v.getClass().getMethod("putString", String.class, String.class);
            v = method.invoke(v, PREFS_DEVICE_ID, serial);
            method = v.getClass().getMethod("commit", new Class[0]);
            method.invoke(v, new Object[0]);
            return serial;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public String getOSSerialNumber(boolean enableSuperUser, boolean enableGUI) {
        Object androidContext;
        try {
            androidContext = Android.getContext();
        }
        catch (Throwable throwable) {
            return null;
        }
        if (androidContext != null) {
            Object prefs = OperatingSystemAndroidWrapper.getPreferences(androidContext);
            if (prefs == null) {
                return null;
            }
            String serial = OperatingSystemAndroidWrapper.getSerialFromPreferences(prefs);
            if (serial != null) {
                return serial;
            }
            serial = OperatingSystemAndroidWrapper.getAndroidID();
            if (serial != null) {
                return serial;
            }
            serial = OperatingSystemAndroidWrapper.getDeviceID(androidContext);
            if (serial != null) {
                return serial;
            }
            return OperatingSystemAndroidWrapper.randomID(prefs);
        }
        return null;
    }

    @Override
    public String getOSUUID(boolean enableSuperUser, boolean enableGUI) {
        String serial = this.getOSSerialNumber(enableSuperUser, enableGUI);
        if (serial != null) {
            try {
                return UUID.fromString(serial).toString();
            }
            catch (Throwable throwable) {
                try {
                    return UUID.nameUUIDFromBytes(serial.getBytes()).toString();
                }
                catch (Throwable throwable2) {}
            }
        }
        return null;
    }

    @Override
    public OperatingSystemIdentificationType getIdentificationType() {
        return OperatingSystemIdentificationType.OPERATING_SYSTEM;
    }
}

