/*
 * Decompiled with CFR 0.152.
 */
package org.arakhne.afc.vmutil;

import org.arakhne.afc.vmutil.LibraryLoader;
import org.arakhne.afc.vmutil.OperatingSystemAndroidWrapper;
import org.arakhne.afc.vmutil.OperatingSystemDiskUtilWrapper;
import org.arakhne.afc.vmutil.OperatingSystemIdentificationType;
import org.arakhne.afc.vmutil.OperatingSystemNativeWrapper;
import org.arakhne.afc.vmutil.OperatingSystemUDevWrapper;
import org.arakhne.afc.vmutil.OperatingSystemUnknownOsWrapper;
import org.arakhne.afc.vmutil.OperatingSystemWrapper;
import org.eclipse.xtext.xbase.lib.Inline;
import org.eclipse.xtext.xbase.lib.Pure;

public enum OperatingSystem {
    WIN,
    LINUX,
    ANDROID,
    SOLARIS,
    MACOSX,
    FREEBSD,
    NETBSD,
    BSD,
    OPENBSD,
    AIX,
    HPUX,
    OTHER;

    private static final String NULL;
    private static OperatingSystemWrapper nativeWrapper;
    private static String osSerialNumber;
    private static String osUUID;
    private static OperatingSystem currentOSInstance;

    static {
        NULL = new String();
        OperatingSystemIdentificationType type = OperatingSystemIdentificationType.BIOS;
        nativeWrapper = null;
        switch (OperatingSystem.getCurrentOS()) {
            case MACOSX: 
            case FREEBSD: 
            case NETBSD: 
            case BSD: 
            case OPENBSD: {
                nativeWrapper = new OperatingSystemDiskUtilWrapper();
                break;
            }
            case LINUX: {
                nativeWrapper = new OperatingSystemUDevWrapper();
                break;
            }
            case ANDROID: {
                nativeWrapper = new OperatingSystemAndroidWrapper();
                break;
            }
            case WIN: {
                type = OperatingSystemIdentificationType.OPERATING_SYSTEM;
            }
        }
        if (nativeWrapper == null) {
            try {
                LibraryLoader.loadPlatformDependentLibrary("josuuid", System.getProperty("os.name").trim().toLowerCase(), "org/arakhne/vmutil");
                nativeWrapper = new OperatingSystemNativeWrapper(type);
            }
            catch (Throwable throwable) {
                nativeWrapper = new OperatingSystemUnknownOsWrapper();
            }
        }
    }

    @Pure
    public static OperatingSystemIdentificationType getIdentificationType() {
        if (nativeWrapper == null) {
            return OperatingSystemIdentificationType.BIOS;
        }
        return nativeWrapper.getIdentificationType();
    }

    @Pure
    public boolean isCurrentOS() {
        return OperatingSystem.getCurrentOS() == this;
    }

    @Pure
    public boolean isUnixCompliant() {
        switch (this) {
            case LINUX: 
            case ANDROID: 
            case SOLARIS: 
            case MACOSX: 
            case FREEBSD: 
            case NETBSD: 
            case BSD: 
            case OPENBSD: 
            case AIX: 
            case HPUX: {
                return true;
            }
            case WIN: 
            case OTHER: {
                return false;
            }
        }
        return false;
    }

    @Pure
    @Inline(value="System.getProperty(\"os.name\")")
    public static String getCurrentOSName() {
        return System.getProperty("os.name");
    }

    @Pure
    @Inline(value="System.getProperty(\"os.version\")")
    public static String getCurrentOSVersion() {
        return System.getProperty("os.version");
    }

    public static void setCurrentOS(OperatingSystem os) {
        currentOSInstance = os;
    }

    @Pure
    public static OperatingSystem getCurrentOS() {
        if (currentOSInstance == null) {
            String runtimeName;
            String vmName;
            String os = System.getProperty("os.name").trim().toLowerCase();
            currentOSInstance = os.indexOf("windows") >= 0 ? WIN : (os.indexOf("linux") >= 0 ? ((vmName = System.getProperty("java.vm.name").trim().toLowerCase()).indexOf("dalvik") >= 0 ? ANDROID : ((runtimeName = System.getProperty("java.runtime.name").trim().toLowerCase()).indexOf("android") >= 0 ? ANDROID : LINUX)) : (os.indexOf("solaris") >= 0 || os.indexOf("sunos") >= 0 ? SOLARIS : (os.indexOf("mac os x") >= 0 || os.indexOf("macosx") >= 0 ? MACOSX : (os.indexOf("bsd") >= 0 ? (os.indexOf("freebsd") >= 0 ? FREEBSD : (os.indexOf("netbsd") >= 0 ? NETBSD : (os.indexOf("openbsd") >= 0 ? OPENBSD : BSD))) : (os.indexOf("aix") >= 0 ? AIX : (os.indexOf("hp ux") >= 0 ? HPUX : OTHER))))));
        }
        return currentOSInstance;
    }

    @Pure
    public static int getOperatingSystemArchitectureDataModel() {
        return LibraryLoader.getOperatingSystemArchitectureDataModel();
    }

    @Pure
    @Inline(value="OperatingSystem.getOperatingSystemArchitectureDataModel() == 64", imported={OperatingSystem.class})
    public static boolean is64BitOperatingSystem() {
        return OperatingSystem.getOperatingSystemArchitectureDataModel() == 64;
    }

    @Pure
    public static boolean is32BitOperatingSystem() {
        int dataModel = OperatingSystem.getOperatingSystemArchitectureDataModel();
        return dataModel == 32 || dataModel == 0;
    }

    @Pure
    @Inline(value="OperatingSystem.getOSSerialNumber(false, false)", imported={OperatingSystem.class})
    public static String getOSSerialNumber() {
        return OperatingSystem.getOSSerialNumber(false, false);
    }

    @Pure
    public static String getOSSerialNumber(boolean enableSuperUser, boolean enableGUI) {
        if (osSerialNumber == null) {
            if (nativeWrapper != null) {
                osSerialNumber = nativeWrapper.getOSSerialNumber(enableSuperUser, enableGUI);
            }
            if (osSerialNumber == null) {
                osSerialNumber = NULL;
            }
        }
        return osSerialNumber == NULL ? null : osSerialNumber;
    }

    @Pure
    @Inline(value="OperatingSystem.getOSUUID(false, false)", imported={OperatingSystem.class})
    public static String getOSUUID() {
        return OperatingSystem.getOSUUID(false, false);
    }

    @Pure
    public static String getOSUUID(boolean enableSuperUser, boolean enableGUI) {
        if (osUUID == null) {
            if (nativeWrapper != null) {
                osUUID = nativeWrapper.getOSUUID(enableSuperUser, enableGUI);
            }
            if (osUUID == null) {
                osUUID = NULL;
            }
        }
        return osUUID == NULL ? null : osUUID;
    }
}

