/*
 * Decompiled with CFR 0.152.
 */
package org.arakhne.afc.vmutil;

import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import org.arakhne.afc.vmutil.ClassLoaderFinder;
import org.arakhne.afc.vmutil.locale.Locale;
import org.eclipse.xtext.xbase.lib.Pure;

public final class Android {
    public static final String HOME_DIRECTORY = "sdcard";
    public static final String CONFIGURATION_DIRECTORY = "config";
    public static final String DATA_DIRECTORY = "data";
    private static SoftReference<Object> context;
    private static WeakReference<Object> contextResolver;
    private static WeakReference<ClassLoader> contextClassLoader;

    private Android() {
    }

    @Pure
    public static String makeAndroidApplicationName(String applicationName) {
        String fullName = applicationName.indexOf(46) >= 0 ? applicationName : "org.arakhne.partnership." + applicationName;
        return fullName;
    }

    @Pure
    public static Class<?> getContextClass() throws AndroidException {
        try {
            ClassLoader loader = ClassLoaderFinder.findClassLoader();
            return Class.forName("android.content.Context", true, loader);
        }
        catch (Throwable e) {
            throw new AndroidException(e);
        }
    }

    @Pure
    public static Class<?> getContextResolverClass() throws AndroidException {
        try {
            ClassLoader loader = ClassLoaderFinder.findClassLoader();
            return Class.forName("android.content.ContentResolver", true, loader);
        }
        catch (Throwable e) {
            throw new AndroidException(e);
        }
    }

    private static Class<?> getInnerClass(String enclosingClassname, String innerClassname) throws AndroidException {
        ClassLoader loader = ClassLoaderFinder.findClassLoader();
        Throwable ex = null;
        try {
            return Class.forName(String.valueOf(enclosingClassname) + "$" + innerClassname, true, loader);
        }
        catch (Throwable e) {
            ex = e;
            try {
                Class<?> enclosingClass = Class.forName(enclosingClassname, true, loader);
                Class<?>[] classArray = enclosingClass.getClasses();
                int n = classArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Class<?> innerClass = classArray[n2];
                    if (innerClassname.equals(innerClass.getName())) {
                        return innerClass;
                    }
                    ++n2;
                }
            }
            catch (Throwable throwable) {}
        }
        throw new AndroidException(ex);
    }

    @Pure
    public static Class<?> getSecureSettingsClass() throws AndroidException {
        return Android.getInnerClass("android.provider.Settings", "Secure");
    }

    @Pure
    public static Class<?> getSystemSettingsClass() throws AndroidException {
        return Android.getInnerClass("android.provider.Settings", "System");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialize(Object androidContext) throws AndroidException {
        assert (androidContext != null);
        try {
            Class<?> contextType = androidContext.getClass();
            Class<?> contextClass = Android.getContextClass();
            if (!contextClass.isAssignableFrom(contextType)) {
                throw new AndroidException(Locale.getString("E1", androidContext));
            }
            Class<Android> clazz = Android.class;
            synchronized (Android.class) {
                contextResolver = null;
                context = new SoftReference<Object>(androidContext);
                // ** MonitorExit[var3_5] (shouldn't be in output)
            }
        }
        catch (AssertionError e) {
            throw e;
        }
        catch (Throwable e) {
            throw new AndroidException(e);
        }
        {
            ClassLoaderFinder.setPreferredClassLoader(Android.getContextClassLoader());
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Pure
    public static Object getContext() throws AndroidException {
        Class<Android> clazz = Android.class;
        synchronized (Android.class) {
            if (context == null) {
                throw new AndroidException();
            }
            Object ctx = context.get();
            // ** MonitorExit[var1] (shouldn't be in output)
            if (ctx == null) {
                throw new AndroidException();
            }
            return ctx;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Pure
    public static ClassLoader getContextClassLoader() throws AndroidException {
        Class<Android> clazz = Android.class;
        synchronized (Android.class) {
            ClassLoader cl;
            ClassLoader classLoader = cl = contextClassLoader == null ? null : (ClassLoader)contextClassLoader.get();
            if (cl != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return cl;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            Object context = Android.getContext();
            try {
                Method method = context.getClass().getMethod("getClassLoader", new Class[0]);
                Object classLoader2 = method.invoke(context, new Object[0]);
                ClassLoader cl2 = (ClassLoader)classLoader2;
                Class<Android> clazz2 = Android.class;
                synchronized (Android.class) {
                    contextClassLoader = new WeakReference<ClassLoader>(cl2);
                    // ** MonitorExit[var4_5] (shouldn't be in output)
                    return cl2;
                }
            }
            catch (Exception e) {
                throw new AndroidException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Pure
    public static Object getContextResolver() throws AndroidException {
        Class<Android> clazz = Android.class;
        synchronized (Android.class) {
            Object resolver = contextResolver == null ? null : (Object)contextResolver.get();
            // ** MonitorExit[var1] (shouldn't be in output)
            if (resolver == null) {
                Object context = Android.getContext();
                try {
                    Class<?> resolverType = Android.getContextResolverClass();
                    Class<?> contextType = context.getClass();
                    Method getContextResolverMethod = contextType.getMethod("getContentResolver", new Class[0]);
                    resolver = getContextResolverMethod.invoke(context, new Object[0]);
                    resolver = resolverType.cast(resolver);
                    Class<Android> clazz2 = Android.class;
                    synchronized (Android.class) {
                        contextResolver = new WeakReference<Object>(resolver);
                        // ** MonitorExit[var5_7] (shouldn't be in output)
                    }
                }
                catch (AssertionError e) {
                    throw e;
                }
                catch (Throwable e) {
                    throw new AndroidException(e);
                }
            }
            {
                return resolver;
            }
        }
    }

    public static class AndroidException
    extends Exception {
        private static final long serialVersionUID = 1521675695582278476L;

        public AndroidException() {
        }

        public AndroidException(String message) {
            super(message);
        }

        public AndroidException(Throwable exception) {
            super(exception);
        }

        public AndroidException(String message, Throwable exception) {
            super(message, exception);
        }
    }
}

