/*
 * Decompiled with CFR 0.152.
 */
package org.arakhne.afc.sizediterator;

import java.util.LinkedList;
import java.util.NoSuchElementException;
import org.arakhne.afc.sizediterator.SizedIterator;
import org.eclipse.xtext.xbase.lib.Pure;

public class MultiSizedIterator<M>
implements SizedIterator<M> {
    private final LinkedList<SizedIterator<? extends M>> iterators = new LinkedList();
    private int total;
    private int returned;
    private SizedIterator<? extends M> iterator;
    private boolean update;
    private M next;

    public void addIterator(SizedIterator<? extends M> iterator) {
        if (this.iterators.add(iterator)) {
            this.total += iterator.totalSize();
            this.update = true;
        }
    }

    private void searchNext() {
        this.next = null;
        while (!(this.iterator != null && this.iterator.hasNext() || this.iterators.isEmpty())) {
            this.iterator = this.iterators.removeFirst();
        }
        if (this.iterator != null && this.iterator.hasNext()) {
            this.next = this.iterator.next();
        }
        this.update = false;
    }

    @Override
    @Pure
    public boolean hasNext() {
        if (this.next == null && this.update) {
            this.searchNext();
        }
        return this.next != null;
    }

    @Override
    public M next() {
        M v;
        if (this.next == null && this.update) {
            this.searchNext();
        }
        if ((v = this.next) == null) {
            throw new NoSuchElementException();
        }
        ++this.returned;
        this.searchNext();
        return v;
    }

    @Override
    @Pure
    public int totalSize() {
        return this.total;
    }

    @Override
    @Pure
    public int rest() {
        return this.total - this.returned;
    }

    @Override
    @Pure
    public int index() {
        return this.totalSize() - this.rest();
    }
}

