/*
 * Decompiled with CFR 0.152.
 */
package org.arakhne.afc.sizediterator;

import java.util.Collection;
import java.util.Iterator;
import org.arakhne.afc.sizediterator.SizedIterator;
import org.eclipse.xtext.xbase.lib.Pure;

public class CollectionSizedIterator<OBJECTT>
implements SizedIterator<OBJECTT> {
    private final Iterator<OBJECTT> iterator;
    private int length;
    private int index;

    public CollectionSizedIterator(Collection<OBJECTT> collection) {
        this.iterator = collection.iterator();
        this.length = collection.size();
        this.index = -1;
    }

    @Override
    @Pure
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public OBJECTT next() {
        OBJECTT n = this.iterator.next();
        ++this.index;
        return n;
    }

    @Override
    public void remove() {
        this.iterator.remove();
        --this.length;
        --this.index;
    }

    @Override
    @Pure
    public int index() {
        return this.index;
    }

    @Override
    @Pure
    public int totalSize() {
        return this.length;
    }

    @Override
    @Pure
    public int rest() {
        return this.length - (this.index + 1);
    }
}

