/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.util;

import io.sarl.lang.annotation.SarlSpecification;
import io.sarl.lang.annotation.SyntheticMember;
import io.sarl.lang.core.Address;
import io.sarl.lang.core.Scope;
import io.sarl.util.AddressScope;
import org.eclipse.xtext.xbase.lib.ExclusiveRange;
import org.eclipse.xtext.xbase.lib.Inline;
import org.eclipse.xtext.xbase.lib.Pure;

@SarlSpecification(value="0.5")
public final class Scopes {
    private static final Scope<?> ALL = new AlwaysTrueScope();

    private Scopes() {
    }

    public static <T> Scope<T> allParticipants() {
        return ALL;
    }

    public static Scope<Address> addresses(Address ... addressArray) {
        return new AddressScope(addressArray);
    }

    public static Scope<Address> notAddresses(Address ... addressArray) {
        return Scopes.not(Scopes.addresses(addressArray));
    }

    public static Scope<Address> not(Scope<Address> scope) {
        return new NotScope<Address>(scope);
    }

    public static Scope<Address> or(Scope<Address> scope, Scope<Address> scope2) {
        return new OrScope<Address>(scope, scope2);
    }

    public static Scope<Address> and(Scope<Address> scope, Scope<Address> scope2) {
        return new AndScope<Address>(scope, scope2);
    }

    public static Scope<Address> xor(Scope<Address> scope, Scope<Address> scope2) {
        return new XorScope<Address>(scope, scope2);
    }

    @SarlSpecification(value="0.5")
    private static class AlwaysTrueScope
    implements Scope<Object> {
        @SyntheticMember
        private static final long serialVersionUID = -332632675L;

        @Pure
        @Inline(value="\"AlwaysTRUE\"", constantExpression=true)
        public String toString() {
            return "AlwaysTRUE";
        }

        @Override
        @Inline(value="true", constantExpression=true)
        public boolean matches(Object object) {
            return true;
        }

        @SyntheticMember
        public AlwaysTrueScope() {
        }
    }

    @SarlSpecification(value="0.5")
    private static class AndScope<T>
    implements Scope<T> {
        private final Scope<T>[] scopes;
        @SyntheticMember
        private static final long serialVersionUID = 1896010764L;

        @SafeVarargs
        public AndScope(Scope<T> ... scopeArray) {
            this.scopes = scopeArray;
        }

        @Pure
        public String toString() {
            String string = null;
            StringBuilder stringBuilder = new StringBuilder();
            int n = this.scopes.length;
            if (n > 0) {
                stringBuilder.append(this.scopes[0]);
                ExclusiveRange exclusiveRange = new ExclusiveRange(1, n, true);
                for (Integer n2 : exclusiveRange) {
                    stringBuilder.append(" && ");
                    stringBuilder.append(this.scopes[n2]);
                }
            }
            string = stringBuilder.toString();
            return string;
        }

        @Override
        public boolean matches(T t) {
            Scope<T>[] scopeArray = this.scopes;
            int n = this.scopes.length;
            int n2 = 0;
            while (n2 < n) {
                boolean bl;
                Scope<T> scope = scopeArray[n2];
                boolean bl2 = scope.matches(t);
                boolean bl3 = bl = !bl2;
                if (bl) {
                    return false;
                }
                ++n2;
            }
            return true;
        }

        @Pure
        @SyntheticMember
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            AndScope andScope = (AndScope)object;
            if (this.scopes == null ? andScope.scopes != null : !this.scopes.equals(andScope.scopes)) {
                return false;
            }
            return super.equals(object);
        }

        @Pure
        @SyntheticMember
        public int hashCode() {
            int n = super.hashCode();
            n = 31 * n + (this.scopes == null ? 0 : this.scopes.hashCode());
            return n;
        }
    }

    @SarlSpecification(value="0.5")
    private static class NotScope<T>
    implements Scope<T> {
        private final Scope<T> scope;
        @SyntheticMember
        private static final long serialVersionUID = -106786425L;

        public NotScope(Scope<T> scope) {
            this.scope = scope;
        }

        @Pure
        public String toString() {
            String string = this.scope.toString();
            return "! " + string;
        }

        @Override
        public boolean matches(T t) {
            boolean bl = this.scope.matches(t);
            return !bl;
        }

        @Pure
        @SyntheticMember
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            NotScope notScope = (NotScope)object;
            if (this.scope == null ? notScope.scope != null : !this.scope.equals(notScope.scope)) {
                return false;
            }
            return super.equals(object);
        }

        @Pure
        @SyntheticMember
        public int hashCode() {
            int n = super.hashCode();
            n = 31 * n + (this.scope == null ? 0 : this.scope.hashCode());
            return n;
        }
    }

    @SarlSpecification(value="0.5")
    private static class OrScope<T>
    implements Scope<T> {
        private final Scope<T>[] scopes;
        @SyntheticMember
        private static final long serialVersionUID = 1896010764L;

        @SafeVarargs
        public OrScope(Scope<T> ... scopeArray) {
            this.scopes = scopeArray;
        }

        @Pure
        public String toString() {
            String string = null;
            StringBuilder stringBuilder = new StringBuilder();
            int n = this.scopes.length;
            if (n > 0) {
                stringBuilder.append(this.scopes[0]);
                ExclusiveRange exclusiveRange = new ExclusiveRange(1, n, true);
                for (Integer n2 : exclusiveRange) {
                    stringBuilder.append(" || ");
                    stringBuilder.append(this.scopes[n2]);
                }
            }
            string = stringBuilder.toString();
            return string;
        }

        @Override
        public boolean matches(T t) {
            Scope<T>[] scopeArray = this.scopes;
            int n = this.scopes.length;
            int n2 = 0;
            while (n2 < n) {
                Scope<T> scope = scopeArray[n2];
                boolean bl = scope.matches(t);
                if (bl) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        @Pure
        @SyntheticMember
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            OrScope orScope = (OrScope)object;
            if (this.scopes == null ? orScope.scopes != null : !this.scopes.equals(orScope.scopes)) {
                return false;
            }
            return super.equals(object);
        }

        @Pure
        @SyntheticMember
        public int hashCode() {
            int n = super.hashCode();
            n = 31 * n + (this.scopes == null ? 0 : this.scopes.hashCode());
            return n;
        }
    }

    @SarlSpecification(value="0.5")
    private static class XorScope<T>
    implements Scope<T> {
        private final Scope<T>[] scopes;
        @SyntheticMember
        private static final long serialVersionUID = 1896010764L;

        @SafeVarargs
        public XorScope(Scope<T> ... scopeArray) {
            this.scopes = scopeArray;
        }

        @Pure
        public String toString() {
            String string = null;
            StringBuilder stringBuilder = new StringBuilder();
            int n = this.scopes.length;
            if (n > 0) {
                stringBuilder.append(this.scopes[0]);
                ExclusiveRange exclusiveRange = new ExclusiveRange(1, n, true);
                for (Integer n2 : exclusiveRange) {
                    stringBuilder.append(" ^ ");
                    stringBuilder.append(this.scopes[n2]);
                }
            }
            string = stringBuilder.toString();
            return string;
        }

        @Override
        public boolean matches(T t) {
            boolean bl = false;
            boolean bl2 = false;
            Scope<T>[] scopeArray = this.scopes;
            int n = this.scopes.length;
            int n2 = 0;
            while (n2 < n) {
                Scope<T> scope = scopeArray[n2];
                boolean bl3 = scope.matches(t);
                if (bl3) {
                    if (bl2) {
                        return false;
                    }
                    bl2 = true;
                }
                ++n2;
            }
            bl = bl2;
            return bl;
        }

        @Pure
        @SyntheticMember
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            XorScope xorScope = (XorScope)object;
            if (this.scopes == null ? xorScope.scopes != null : !this.scopes.equals(xorScope.scopes)) {
                return false;
            }
            return super.equals(object);
        }

        @Pure
        @SyntheticMember
        public int hashCode() {
            int n = super.hashCode();
            n = 31 * n + (this.scopes == null ? 0 : this.scopes.hashCode());
            return n;
        }
    }
}

