/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.util;

import com.google.common.base.Objects;
import io.sarl.lang.annotation.SarlSpecification;
import io.sarl.lang.annotation.SyntheticMember;
import io.sarl.lang.util.SynchronizedCollection;
import io.sarl.lang.util.SynchronizedSet;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Inline;
import org.eclipse.xtext.xbase.lib.Pure;

@SarlSpecification(value="0.5")
public final class Collections3 {
    public static final SynchronizedSet<Object> EMPTY_SET = new EmptySet();

    private Collections3() {
    }

    public static <T> SynchronizedSet<T> synchronizedSet(Set<T> set, Object object) {
        return new SynchronizedSetWrapper<T>(set, object);
    }

    public static <T> SynchronizedCollection<T> synchronizedCollection(Collection<T> collection, Object object) {
        return new SynchronizedCollectionWrapper<T>(collection, object);
    }

    public static <T> SynchronizedSet<T> emptySynchronizedSet() {
        return EMPTY_SET;
    }

    public static <T> SynchronizedSet<T> synchronizedSingleton(T t) {
        return new SingletonSet<T>(t);
    }

    public static <T> SynchronizedSet<T> unmodifiableSynchronizedSet(SynchronizedSet<T> synchronizedSet) {
        return new UnmodifiableSetWrapper<T>(synchronizedSet);
    }

    public static <T> SynchronizedSet<T> unmodifiableSynchronizedSet(Set<T> set, Object object) {
        return new UnmodifiableSynchronizedSetWrapper<T>(set, object);
    }

    @SarlSpecification(value="0.5")
    private static class EmptySet
    extends AbstractSet<Object>
    implements SynchronizedSet<Object>,
    Serializable {
        private final Object mutex = new Object();
        @SyntheticMember
        private static final long serialVersionUID = -2845211799L;

        EmptySet() {
        }

        @Override
        public Object mutex() {
            return this.mutex;
        }

        @Override
        @Pure
        public Iterator<Object> iterator() {
            return Collections.emptyIterator();
        }

        @Override
        @Pure
        @Inline(value="0", constantExpression=true)
        public int size() {
            return 0;
        }

        @Override
        @Pure
        @SyntheticMember
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            EmptySet emptySet = (EmptySet)object;
            if (this.mutex == null ? emptySet.mutex != null : !this.mutex.equals(emptySet.mutex)) {
                return false;
            }
            return super.equals(object);
        }

        @Override
        @Pure
        @SyntheticMember
        public int hashCode() {
            int n = super.hashCode();
            n = 31 * n + (this.mutex == null ? 0 : this.mutex.hashCode());
            return n;
        }
    }

    @SarlSpecification(value="0.5")
    private static class SingletonSet<T>
    extends AbstractSet<T>
    implements SynchronizedSet<T>,
    Serializable {
        private final T singleton;
        @SyntheticMember
        private static final long serialVersionUID = -4443989993L;

        SingletonSet(T t) {
            this.singleton = t;
        }

        @Override
        public Object mutex() {
            return this;
        }

        @Override
        @Pure
        public Iterator<T> iterator() {
            return Collections.singleton(this.singleton).iterator();
        }

        @Override
        @Pure
        @Inline(value="1", constantExpression=true)
        public int size() {
            return 1;
        }

        @Override
        @Pure
        @SyntheticMember
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            SingletonSet singletonSet = (SingletonSet)object;
            if (this.singleton == null ? singletonSet.singleton != null : !this.singleton.equals(singletonSet.singleton)) {
                return false;
            }
            return super.equals(object);
        }

        @Override
        @Pure
        @SyntheticMember
        public int hashCode() {
            int n = super.hashCode();
            n = 31 * n + (this.singleton == null ? 0 : this.singleton.hashCode());
            return n;
        }
    }

    @SarlSpecification(value="0.5")
    private static class SynchronizedCollectionWrapper<E>
    implements Serializable,
    SynchronizedCollection<E> {
        final Collection<E> collection;
        final Object mutex;
        @SyntheticMember
        private static final long serialVersionUID = -3744133218L;

        public SynchronizedCollectionWrapper(Collection<E> collection, Object object) {
            this.collection = collection;
            this.mutex = object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Pure
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            Object object2 = this.mutex;
            synchronized (object2) {
                return Objects.equal(this.collection, object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Pure
        public int hashCode() {
            int n = 0;
            Object object = this.mutex;
            synchronized (object) {
                n = this.collection.hashCode();
            }
            return n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Pure
        public int size() {
            int n = 0;
            Object object = this.mutex;
            synchronized (object) {
                n = this.collection.size();
            }
            return n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Pure
        public boolean isEmpty() {
            boolean bl = false;
            Object object = this.mutex;
            synchronized (object) {
                bl = this.collection.isEmpty();
            }
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Pure
        public boolean contains(Object object) {
            boolean bl = false;
            Object object2 = this.mutex;
            synchronized (object2) {
                bl = this.collection.contains(object);
            }
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Pure
        public Object[] toArray() {
            Object[] objectArray = null;
            Object object = this.mutex;
            synchronized (object) {
                objectArray = this.collection.toArray();
            }
            return objectArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Pure
        public <T> T[] toArray(T[] TArray) {
            T[] TArray2 = null;
            Object object = this.mutex;
            synchronized (object) {
                TArray2 = this.collection.toArray(TArray);
            }
            return TArray2;
        }

        @Override
        @Pure
        public Iterator<E> iterator() {
            return this.collection.iterator();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean add(E e) {
            boolean bl = false;
            Object object = this.mutex;
            synchronized (object) {
                bl = this.collection.add(e);
            }
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean remove(Object object) {
            boolean bl = false;
            Object object2 = this.mutex;
            synchronized (object2) {
                bl = this.collection.remove(object);
            }
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Pure
        public boolean containsAll(Collection<?> collection) {
            boolean bl = false;
            Object object = this.mutex;
            synchronized (object) {
                bl = this.collection.containsAll(collection);
            }
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAll(Collection<? extends E> collection) {
            boolean bl = false;
            Object object = this.mutex;
            synchronized (object) {
                bl = this.collection.addAll(collection);
            }
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean removeAll(Collection<?> collection) {
            boolean bl = false;
            Object object = this.mutex;
            synchronized (object) {
                bl = this.collection.removeAll(collection);
            }
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean retainAll(Collection<?> collection) {
            boolean bl = false;
            Object object = this.mutex;
            synchronized (object) {
                bl = this.collection.retainAll(collection);
            }
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Object object = this.mutex;
            synchronized (object) {
                this.collection.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Pure
        public String toString() {
            String string = null;
            Object object = this.mutex;
            synchronized (object) {
                string = this.collection.toString();
            }
            return string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeObject(ObjectOutputStream objectOutputStream) {
            try {
                Object object = this.mutex;
                synchronized (object) {
                    objectOutputStream.defaultWriteObject();
                }
            }
            catch (Throwable throwable) {
                throw Exceptions.sneakyThrow(throwable);
            }
        }

        @Override
        public Object mutex() {
            return this.mutex;
        }
    }

    @SarlSpecification(value="0.5")
    private static class SynchronizedSetWrapper<E>
    extends SynchronizedCollectionWrapper<E>
    implements SynchronizedSet<E> {
        @SyntheticMember
        private static final long serialVersionUID = -680429322L;

        SynchronizedSetWrapper(Set<E> set, Object object) {
            super(set, object);
        }
    }

    @SarlSpecification(value="0.5")
    private static class UnmodifiableIterator<E>
    implements Iterator<E> {
        private final Iterator<E> iterator;

        UnmodifiableIterator(Iterator<E> iterator) {
            this.iterator = iterator;
        }

        @Override
        @Pure
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public E next() {
            return this.iterator.next();
        }

        @Pure
        @SyntheticMember
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            UnmodifiableIterator unmodifiableIterator = (UnmodifiableIterator)object;
            if (this.iterator == null ? unmodifiableIterator.iterator != null : !this.iterator.equals(unmodifiableIterator.iterator)) {
                return false;
            }
            return super.equals(object);
        }

        @Pure
        @SyntheticMember
        public int hashCode() {
            int n = super.hashCode();
            n = 31 * n + (this.iterator == null ? 0 : this.iterator.hashCode());
            return n;
        }
    }

    @SarlSpecification(value="0.5")
    private static class UnmodifiableSetWrapper<E>
    implements Serializable,
    SynchronizedSet<E> {
        private final SynchronizedSet<E> collection;
        @SyntheticMember
        private static final long serialVersionUID = -5940196918L;

        UnmodifiableSetWrapper(SynchronizedSet<E> synchronizedSet) {
            this.collection = synchronizedSet;
        }

        @Override
        @Pure
        public int size() {
            return this.collection.size();
        }

        @Override
        @Pure
        public boolean isEmpty() {
            return this.collection.isEmpty();
        }

        @Override
        @Pure
        public boolean contains(Object object) {
            return this.collection.contains(object);
        }

        @Override
        @Pure
        public Iterator<E> iterator() {
            Iterator iterator = this.collection.iterator();
            return new UnmodifiableIterator(iterator);
        }

        @Override
        @Pure
        public Object[] toArray() {
            return this.collection.toArray();
        }

        @Override
        @Pure
        public <T> T[] toArray(T[] TArray) {
            return this.collection.toArray(TArray);
        }

        @Override
        public boolean add(E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Pure
        public boolean containsAll(Collection<?> collection) {
            return this.collection.containsAll(collection);
        }

        @Override
        public boolean addAll(Collection<? extends E> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object mutex() {
            return this.collection.mutex();
        }

        @Override
        @Pure
        @SyntheticMember
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            UnmodifiableSetWrapper unmodifiableSetWrapper = (UnmodifiableSetWrapper)object;
            if (this.collection == null ? unmodifiableSetWrapper.collection != null : !this.collection.equals(unmodifiableSetWrapper.collection)) {
                return false;
            }
            return super.equals(object);
        }

        @Override
        @Pure
        @SyntheticMember
        public int hashCode() {
            int n = super.hashCode();
            n = 31 * n + (this.collection == null ? 0 : this.collection.hashCode());
            return n;
        }
    }

    @SarlSpecification(value="0.5")
    private static class UnmodifiableSynchronizedSetWrapper<E>
    extends SynchronizedSetWrapper<E> {
        UnmodifiableSynchronizedSetWrapper(Set<E> set, Object object) {
            super(set, object);
        }

        @Override
        public boolean add(E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends E> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        @Pure
        public Iterator<E> iterator() {
            Iterator iterator = super.iterator();
            return new UnmodifiableIterator(iterator);
        }
    }
}

