/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.core;

import io.sarl.lang.core.SpaceSpecification;
import java.io.Serializable;
import java.util.UUID;
import org.eclipse.xtext.xbase.lib.Pure;

public class SpaceID
implements Serializable,
Comparable<SpaceID> {
    private static final long serialVersionUID = 8764568066583474825L;
    private final UUID id;
    private final UUID contextID;
    private final transient Class<? extends SpaceSpecification<?>> spaceSpec;

    public SpaceID(UUID contextID, UUID id, Class<? extends SpaceSpecification<?>> spaceSpec) {
        assert (contextID != null);
        assert (id != null);
        this.id = id;
        this.contextID = contextID;
        this.spaceSpec = spaceSpec;
    }

    @Pure
    public UUID getID() {
        return this.id;
    }

    @Pure
    public UUID getContextID() {
        return this.contextID;
    }

    @Pure
    public Class<? extends SpaceSpecification<?>> getSpaceSpecification() {
        return this.spaceSpec;
    }

    @Pure
    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.contextID == null ? 0 : this.contextID.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    @Pure
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SpaceID other = (SpaceID)obj;
        if (!this.equalsContext(other)) {
            return false;
        }
        return this.equalsID(other);
    }

    private boolean equalsContext(SpaceID other) {
        return !(this.contextID == null ? other.contextID != null : !this.contextID.equals(other.contextID));
    }

    private boolean equalsID(SpaceID other) {
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    @Pure
    public String toString() {
        return "SpaceID [id=" + this.id + ", contextID=" + this.contextID + ", spaceSpec=" + this.spaceSpec + "]";
    }

    @Override
    @Pure
    public int compareTo(SpaceID otherID) {
        int cmp = this.contextID.compareTo(otherID.contextID);
        if (cmp != 0) {
            return cmp;
        }
        return this.id.compareTo(otherID.id);
    }
}

