/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.core;

import com.google.common.reflect.TypeToken;
import io.sarl.lang.annotation.SarlSpecification;
import io.sarl.lang.core.Address;
import io.sarl.lang.core.AgentProtectedAPIObject;
import io.sarl.lang.core.BuiltinCapacitiesProvider;
import io.sarl.lang.core.Capacity;
import io.sarl.lang.core.Event;
import io.sarl.lang.core.Identifiable;
import io.sarl.lang.core.Skill;
import io.sarl.lang.core.UnimplementedCapacityException;
import io.sarl.lang.util.ClearableReference;
import java.security.InvalidParameterException;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.eclipse.xtext.xbase.lib.Inline;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;

@SarlSpecification(value="0.5")
public class Agent
extends AgentProtectedAPIObject
implements Identifiable {
    private final UUID id;
    private final Map<Class<? extends Capacity>, ClearableReference<Skill>> skills = new ConcurrentHashMap<Class<? extends Capacity>, ClearableReference<Skill>>();
    private final UUID parentID;

    @Inject
    public Agent(BuiltinCapacitiesProvider provider, UUID parentID, UUID agentID) {
        Map<Class<? extends Capacity>, Skill> builtinCapacities;
        this.parentID = parentID;
        UUID uUID = this.id = agentID == null ? UUID.randomUUID() : agentID;
        if (provider != null && (builtinCapacities = provider.getBuiltinCapacities(this)) != null && !builtinCapacities.isEmpty()) {
            for (Map.Entry<Class<? extends Capacity>, Skill> bic : builtinCapacities.entrySet()) {
                this.mapCapacity(bic.getKey(), bic.getValue());
            }
        }
    }

    public Agent(UUID parentID, UUID agentID) {
        this(null, parentID, agentID);
    }

    private ClearableReference<Skill> mapCapacity(Class<? extends Capacity> capacity, Skill skill) {
        return this.skills.put(capacity, new ClearableReference<Skill>(skill));
    }

    @Override
    protected String attributesToString() {
        StringBuilder builder = new StringBuilder();
        builder.append("id = ");
        builder.append(this.id);
        builder.append(", parentID=");
        builder.append(this.parentID);
        return builder.toString();
    }

    @Pure
    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " [" + this.attributesToString() + "]";
    }

    @Pure
    public UUID getParentID() {
        return this.parentID;
    }

    @Override
    @Pure
    public UUID getID() {
        return this.id;
    }

    @Inline(value="setSkill($2, $1)")
    @Deprecated
    protected <S extends Skill> S setSkill(Class<? extends Capacity> capacity, S skill) {
        return this.setSkill(skill, capacity);
    }

    @Override
    @SafeVarargs
    protected final <S extends Skill> S setSkill(S skill, Class<? extends Capacity> ... capacities) {
        assert (skill != null) : "the skill parameter must not be null";
        skill.setOwner(this);
        if (capacities == null || capacities.length == 0) {
            Agent.runOnImplementedCapacities(skill, capacity -> {
                Skill oldSkill;
                ClearableReference<Skill> oldS = this.mapCapacity((Class<? extends Capacity>)capacity, skill);
                skill.registerUse();
                if (oldS != null && (oldSkill = oldS.clear()) != null && oldSkill != skill) {
                    oldSkill.unregisterUse();
                }
            });
        } else {
            Class<? extends Capacity>[] classArray = capacities;
            int n = capacities.length;
            int n2 = 0;
            while (n2 < n) {
                Skill oldSkill;
                Class<? extends Capacity> capacity2 = classArray[n2];
                assert (capacity2 != null) : "the capacity parameter must not be null";
                assert (capacity2.isInterface()) : "the capacity parameter must be an interface";
                if (!capacity2.isInstance(skill)) {
                    throw new InvalidParameterException("the skill must implement the given capacity " + capacity2.getName());
                }
                ClearableReference<Skill> oldS = this.mapCapacity(capacity2, skill);
                skill.registerUse();
                if (oldS != null && (oldSkill = oldS.clear()) != null && oldSkill != skill) {
                    oldSkill.unregisterUse();
                }
                ++n2;
            }
        }
        return skill;
    }

    private static void runOnImplementedCapacities(Skill skill, Procedures.Procedure1<Class<? extends Capacity>> callback) {
        ((Stream)TypeToken.of(skill.getClass()).getTypes().interfaces().stream().parallel()).forEach(it -> {
            Class type = it.getRawType();
            if (Capacity.class.isAssignableFrom(type) && !Capacity.class.equals(type)) {
                callback.apply(type.asSubclass(Capacity.class));
            }
        });
    }

    @Override
    @Inline(value="setSkill($2, $1)")
    protected <S extends Skill> void operator_mappedTo(Class<? extends Capacity> capacity, S skill) {
        this.setSkill(skill, capacity);
    }

    @Override
    protected <S extends Capacity> S clearSkill(Class<S> capacity) {
        Skill skill;
        assert (capacity != null);
        ClearableReference<Skill> reference = this.skills.remove(capacity);
        if (reference != null && (skill = reference.clear()) != null) {
            skill.unregisterUse();
            return (S)((Capacity)capacity.cast(skill));
        }
        return null;
    }

    @Override
    @Pure
    protected final <S extends Capacity> S getSkill(Class<S> capacity) {
        assert (capacity != null);
        return this.$castSkill(capacity, this.$getSkill(capacity));
    }

    @Pure
    protected <S extends Capacity> S $castSkill(Class<S> capacity, ClearableReference<Skill> skillReference) {
        Capacity skill = (Capacity)capacity.cast(skillReference.get());
        if (skill == null) {
            throw new UnimplementedCapacityException(capacity, this.getID());
        }
        return (S)skill;
    }

    @Override
    @Pure
    protected ClearableReference<Skill> $getSkill(Class<? extends Capacity> capacity) {
        ClearableReference<Skill> skill = this.skills.get(capacity);
        if (skill == null) {
            throw new UnimplementedCapacityException(capacity, this.getID());
        }
        return skill;
    }

    @Override
    @Pure
    protected boolean hasSkill(Class<? extends Capacity> capacity) {
        assert (capacity != null);
        return this.skills.containsKey(capacity);
    }

    @Override
    @Pure
    protected boolean isMe(Address address) {
        return address != null && this.id.equals(address.getUUID());
    }

    @Override
    @Pure
    protected boolean isMe(UUID uID) {
        return uID != null && this.id.equals(uID);
    }

    @Override
    @Pure
    protected boolean isFromMe(Event event) {
        return event != null && this.isMe(event.getSource());
    }
}

