/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.eventdispatching;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.reflect.TypeToken;
import io.sarl.eventdispatching.BehaviorGuardEvaluator;
import io.sarl.eventdispatching.Messages;
import io.sarl.lang.annotation.DefaultValue;
import io.sarl.lang.annotation.DefaultValueSource;
import io.sarl.lang.annotation.DefaultValueUse;
import io.sarl.lang.annotation.PerceptGuardEvaluator;
import io.sarl.lang.annotation.SarlSourceCode;
import io.sarl.lang.annotation.SarlSpecification;
import io.sarl.lang.annotation.SyntheticMember;
import io.sarl.lang.core.Event;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;

@SarlSpecification(value="0.5")
public class BehaviorGuardEvaluatorRegistry {
    private static final LoadingCache<Class<?>, ImmutableSet<Class<?>>> FLATTEN_HIERARCHY_CACHE = CacheBuilder.newBuilder().weakKeys().build(new CacheLoader<Class<?>, ImmutableSet<Class<?>>>(){

        @Override
        public ImmutableSet<Class<?>> load(Class<?> clazz) throws Exception {
            return BehaviorGuardEvaluatorRegistry.getTypeHierarchyOnDemand(clazz);
        }
    });
    private static final LoadingCache<Class<?>, Map<Class<? extends Event>, Collection<Method>>> PERCEPT_GUARD_EVALUATOR_METHOD_CACHE = CacheBuilder.newBuilder().weakKeys().build(new CacheLoader<Class<?>, Map<Class<? extends Event>, Collection<Method>>>(){

        @Override
        public Map<Class<? extends Event>, Collection<Method>> load(Class<?> clazz) throws Exception {
            return BehaviorGuardEvaluatorRegistry.getAnnotatedMethodMapOnDemand(clazz);
        }
    });
    private final Map<Class<? extends Event>, Pair<Functions.Function1<? super Event, ? extends Boolean>, Set<BehaviorGuardEvaluator>>> behaviorGuardEvaluators;
    private boolean active = true;
    @SyntheticMember
    @SarlSourceCode(value="null")
    private static final Functions.Function1<? super Event, ? extends Boolean> $DEFAULT_VALUE$REGISTER_0 = null;
    @SyntheticMember
    @SarlSourceCode(value="null")
    private static final Procedures.Procedure1<? super Object> $DEFAULT_VALUE$REGISTER_1 = null;
    @SyntheticMember
    @SarlSourceCode(value="null")
    private static final Procedures.Procedure1<? super Object> $DEFAULT_VALUE$UNREGISTERALL_0 = null;
    @SyntheticMember
    @SarlSourceCode(value="null")
    private static final Procedures.Procedure1<? super Object> $DEFAULT_VALUE$UNREGISTER_0 = null;

    private static Class<?> reloadClass(Class<?> clazz, Class<?> clazz2) {
        ClassLoader classLoader = clazz.getClassLoader();
        if (classLoader == null) {
            classLoader = clazz2.getClassLoader();
        }
        try {
            return classLoader.loadClass(clazz2.getName());
        }
        catch (Throwable throwable) {
            if (throwable instanceof Throwable) {
                return clazz2;
            }
            throw Exceptions.sneakyThrow(throwable);
        }
    }

    private static <T> T safeCast(Object object) {
        return (T)object;
    }

    private static Set<Class<?>> exploreTypeHierarchy(Class<?> clazz) {
        return (Set)BehaviorGuardEvaluatorRegistry.safeCast(TypeToken.of(clazz).getTypes().rawTypes());
    }

    @Pure
    private static ImmutableSet<Class<?>> getTypeHierarchyOnDemand(Class<?> clazz) {
        ImmutableSet<Class<?>> immutableSet = null;
        Set<Class<?>> set = BehaviorGuardEvaluatorRegistry.exploreTypeHierarchy(clazz);
        try {
            Class<?> clazz3 = BehaviorGuardEvaluatorRegistry.reloadClass(clazz, Event.class);
            boolean bl = clazz3.isAssignableFrom(clazz);
            if (bl) {
                Functions.Function1<Class, Boolean> function1 = clazz2 -> clazz3.isAssignableFrom((Class<?>)clazz2);
                return ImmutableSet.copyOf(IterableExtensions.filter(set, function1));
            }
        }
        catch (Throwable throwable) {
            if (throwable instanceof Exception) {
                Exception cfr_ignored_0 = (Exception)throwable;
            }
            throw Exceptions.sneakyThrow(throwable);
        }
        immutableSet = ImmutableSet.copyOf(set);
        return immutableSet;
    }

    @Pure
    private static Map<Class<? extends Event>, Collection<Method>> getAnnotatedMethodMapOnDemand(Class<?> clazz3) {
        Collection<Method> collection;
        Object object;
        Method method;
        Object object2;
        Object object3;
        ImmutableMap<Class<? extends Event>, Collection<Method>> immutableMap = null;
        Set<Class<?>> set = BehaviorGuardEvaluatorRegistry.exploreTypeHierarchy(clazz3);
        Functions.Function1<Class, Boolean> function1 = clazz -> !clazz.isInterface() && !Objects.equal(Object.class, clazz);
        Iterable<Class> iterable = IterableExtensions.filter(set, function1);
        TreeMap<ArrayList<Method>, Method> treeMap = new TreeMap<ArrayList<Method>, Method>();
        for (Class object42 : iterable) {
            object3 = object42.getDeclaredMethods();
            object2 = object3;
            int classArray = ((Method[])object3).length;
            int iterator = 0;
            while (iterator < classArray) {
                method = object2[iterator];
                if (method.isAnnotationPresent(PerceptGuardEvaluator.class) && !method.isSynthetic()) {
                    object = method.getParameterTypes();
                    collection = new MethodIdentifier(method, (Class<?>[])object);
                    treeMap.putIfAbsent((ArrayList<Method>)collection, method);
                }
                ++iterator;
            }
        }
        Comparator comparator = (clazz, clazz2) -> {
            String string = clazz.getName();
            String string2 = clazz2.getName();
            return string.compareTo(string2);
        };
        TreeMap treeMap2 = new TreeMap(comparator);
        object3 = treeMap.values();
        Iterator iterator = object3.iterator();
        while (iterator.hasNext()) {
            method = (Method)iterator.next();
            Class<?>[] classArray = method.getParameterTypes();
            object2 = classArray[0];
            object = object2;
            collection = (Collection)treeMap2.get(object);
            if (collection == null) {
                collection = CollectionLiterals.newArrayList(new Method[0]);
                treeMap2.put(object, collection);
            }
            collection.add(method);
        }
        immutableMap = ImmutableMap.copyOf(treeMap2);
        return immutableMap;
    }

    @Pure
    private static Map<Class<? extends Event>, Collection<Method>> getAnnotatedMethodsPerEvent(Class<?> clazz) {
        Map<Class<? extends Event>, Collection<Method>> map = null;
        try {
            map = PERCEPT_GUARD_EVALUATOR_METHOD_CACHE.getUnchecked(clazz);
        }
        catch (Throwable throwable) {
            if (throwable instanceof Exception) {
                Exception exception = (Exception)throwable;
                throw Throwables.propagate(exception);
            }
            throw Exceptions.sneakyThrow(throwable);
        }
        return map;
    }

    public BehaviorGuardEvaluatorRegistry() {
        this(true);
    }

    public BehaviorGuardEvaluatorRegistry(final boolean bl) {
        this((Map<Class<? extends Event>, Pair<Functions.Function1<? super Event, ? extends Boolean>, Set<BehaviorGuardEvaluator>>>)new Functions.Function0<Map<Class<? extends Event>, Pair<Functions.Function1<? super Event, ? extends Boolean>, Set<BehaviorGuardEvaluator>>>>(){

            @Override
            public Map<Class<? extends Event>, Pair<Functions.Function1<? super Event, ? extends Boolean>, Set<BehaviorGuardEvaluator>>> apply() {
                Map map = null;
                map = bl ? Maps.newConcurrentMap() : Maps.newHashMap();
                return map;
            }
        }.apply());
    }

    public BehaviorGuardEvaluatorRegistry(Map<Class<? extends Event>, Pair<Functions.Function1<? super Event, ? extends Boolean>, Set<BehaviorGuardEvaluator>>> map) {
        this.behaviorGuardEvaluators = map;
    }

    @DefaultValueSource
    public void register(Object object, @DefaultValue(value="io.sarl.eventdispatching.BehaviorGuardEvaluatorRegistry#REGISTER_0") Functions.Function1<? super Event, ? extends Boolean> function1, @DefaultValue(value="io.sarl.eventdispatching.BehaviorGuardEvaluatorRegistry#REGISTER_1") Procedures.Procedure1<? super Object> procedure1) {
        if (this.active) {
            boolean bl = false;
            EvaluatorIterator evaluatorIterator = new EvaluatorIterator(object);
            while (evaluatorIterator.hasNext()) {
                Object object2 = evaluatorIterator.next();
                Class clazz = (Class)((Pair)object2).getKey();
                Collection collection = (Collection)((Pair)object2).getValue();
                Pair<Functions.Function1<? super Event, ? extends Boolean>, Set<BehaviorGuardEvaluator>> pair = this.behaviorGuardEvaluators.get(clazz);
                Set<BehaviorGuardEvaluator> set = null;
                if (pair == null) {
                    CopyOnWriteArraySet<BehaviorGuardEvaluator> copyOnWriteArraySet = new CopyOnWriteArraySet<BehaviorGuardEvaluator>();
                    set = copyOnWriteArraySet;
                    Pair<Functions.Function1<? super Event, ? extends Boolean>, Set<BehaviorGuardEvaluator>> pair2 = new Pair<Functions.Function1<? super Event, ? extends Boolean>, Set<BehaviorGuardEvaluator>>(function1, set);
                    this.behaviorGuardEvaluators.put(clazz, pair2);
                    bl = true;
                } else {
                    set = pair.getValue();
                }
                boolean bl2 = set.addAll(collection);
                if (!bl2) continue;
                bl = true;
            }
            if (bl && procedure1 != null) {
                procedure1.apply(object);
            }
        }
    }

    @DefaultValueSource
    public void unregisterAll(@DefaultValue(value="io.sarl.eventdispatching.BehaviorGuardEvaluatorRegistry#UNREGISTERALL_0") Procedures.Procedure1<? super Object> procedure1) {
        if (this.active) {
            this.active = false;
            try {
                if (procedure1 != null) {
                    Iterator<Pair<Functions.Function1<? super Event, ? extends Boolean>, Set<BehaviorGuardEvaluator>>> iterator = this.behaviorGuardEvaluators.values().iterator();
                    Comparator comparator = (object, object2) -> {
                        if (object == object2) {
                            return 0;
                        }
                        int n = System.identityHashCode(object);
                        int n2 = System.identityHashCode(object2);
                        return Integer.valueOf(n).compareTo(n2);
                    };
                    TreeSet<Object> treeSet = new TreeSet<Object>(comparator);
                    while (iterator.hasNext()) {
                        Pair<Functions.Function1<? super Event, ? extends Boolean>, Set<BehaviorGuardEvaluator>> pair = iterator.next();
                        Set<BehaviorGuardEvaluator> set = pair.getValue();
                        for (BehaviorGuardEvaluator behaviorGuardEvaluator : set) {
                            Object object3 = behaviorGuardEvaluator.getTarget();
                            boolean bl = treeSet.add(object3);
                            if (!bl) continue;
                            procedure1.apply(behaviorGuardEvaluator.getTarget());
                        }
                        iterator.remove();
                    }
                } else {
                    this.behaviorGuardEvaluators.clear();
                }
            }
            finally {
                this.active = true;
            }
        }
    }

    @DefaultValueSource
    public void unregister(Object object, @DefaultValue(value="io.sarl.eventdispatching.BehaviorGuardEvaluatorRegistry#UNREGISTER_0") Procedures.Procedure1<? super Object> procedure1) {
        if (this.active) {
            EvaluatorIterator evaluatorIterator = new EvaluatorIterator(object);
            Procedures.Procedure1<? super Object> procedure12 = procedure1;
            while (evaluatorIterator.hasNext()) {
                Object object2 = evaluatorIterator.next();
                Class clazz = (Class)((Pair)object2).getKey();
                Collection collection = (Collection)((Pair)object2).getValue();
                Pair<Functions.Function1<? super Event, ? extends Boolean>, Set<BehaviorGuardEvaluator>> pair = this.behaviorGuardEvaluators.get(clazz);
                if (procedure12 != null && pair != null && pair.getValue() != null && !pair.getValue().isEmpty()) {
                    procedure12.apply(object);
                    procedure12 = null;
                }
                if (pair != null && pair.getValue() != null && pair.getValue().removeAll(collection)) continue;
                if (pair != null && pair.getValue() != null) {
                    pair.getValue().removeAll(collection);
                }
                String string = MessageFormat.format(Messages.BehaviorGuardEvaluatorRegistry_0, object);
                throw new IllegalArgumentException(string);
            }
        }
    }

    @Pure
    public Iterable<BehaviorGuardEvaluator> getBehaviorGuardEvaluators(Event event) {
        ImmutableSet<Class<?>> immutableSet = BehaviorGuardEvaluatorRegistry.flattenHierarchy(event.getClass());
        Iterable<BehaviorGuardEvaluator> iterable = () -> {
            Iterator iterator = immutableSet.iterator();
            return new EvaluatorCollectionIterator(this.behaviorGuardEvaluators, event, iterator, false);
        };
        return iterable;
    }

    @Pure
    public Iterable<BehaviorGuardEvaluator> getBehaviorGuardEvaluatorsFor(Event event, Object object) {
        ImmutableSet<Class<?>> immutableSet = BehaviorGuardEvaluatorRegistry.flattenHierarchy(event.getClass());
        Iterable<BehaviorGuardEvaluator> iterable = () -> {
            EvaluatorCollectionFilteringIterator evaluatorCollectionFilteringIterator = null;
            Iterator iterator = immutableSet.iterator();
            EvaluatorCollectionIterator evaluatorCollectionIterator = new EvaluatorCollectionIterator(this.behaviorGuardEvaluators, event, iterator, true);
            evaluatorCollectionFilteringIterator = new EvaluatorCollectionFilteringIterator(evaluatorCollectionIterator, object);
            return evaluatorCollectionFilteringIterator;
        };
        return iterable;
    }

    @Pure
    public boolean hasRegisteredEventListener(Class<?> clazz) {
        Collection<Pair<Functions.Function1<? super Event, ? extends Boolean>, Set<BehaviorGuardEvaluator>>> collection = this.behaviorGuardEvaluators.values();
        for (Pair<Functions.Function1<? super Event, ? extends Boolean>, Set<BehaviorGuardEvaluator>> pair : collection) {
            Set<BehaviorGuardEvaluator> set = pair.getValue();
            if (set == null) continue;
            for (BehaviorGuardEvaluator behaviorGuardEvaluator : set) {
                Object object = behaviorGuardEvaluator.getTarget();
                boolean bl = clazz.isInstance(object);
                if (!bl) continue;
                return true;
            }
        }
        return false;
    }

    @Pure
    public <T> int getRegisteredEventListeners(Class<T> clazz, Collection<? super T> collection) {
        int n = 0;
        Comparator comparator = (object, object2) -> {
            int n = 0;
            if (object == object2) {
                return 0;
            }
            int n2 = System.identityHashCode(object);
            int n3 = System.identityHashCode(object2);
            n = Integer.valueOf(n2).compareTo(n3);
            return n;
        };
        TreeSet<Object> treeSet = new TreeSet<Object>(comparator);
        Collection<Pair<Functions.Function1<? super Event, ? extends Boolean>, Set<BehaviorGuardEvaluator>>> collection2 = this.behaviorGuardEvaluators.values();
        for (Pair<Functions.Function1<? super Event, ? extends Boolean>, Set<BehaviorGuardEvaluator>> pair : collection2) {
            Set<BehaviorGuardEvaluator> set = pair.getValue();
            if (set == null) continue;
            for (BehaviorGuardEvaluator behaviorGuardEvaluator : set) {
                Object object3 = behaviorGuardEvaluator.getTarget();
                if (!clazz.isInstance(object3) || !treeSet.add(object3) || collection == null) continue;
                T t = clazz.cast(object3);
                collection.add(t);
            }
        }
        n = treeSet.size();
        return n;
    }

    private static ImmutableSet<Class<?>> flattenHierarchy(Class<?> clazz) {
        ImmutableSet<Class<?>> immutableSet = null;
        try {
            immutableSet = FLATTEN_HIERARCHY_CACHE.getUnchecked(clazz);
        }
        catch (Throwable throwable) {
            if (throwable instanceof Exception) {
                Exception exception = (Exception)throwable;
                throw Throwables.propagate(exception.getCause());
            }
            throw Exceptions.sneakyThrow(throwable);
        }
        return immutableSet;
    }

    @DefaultValueUse(value="java.lang.Object,(io.sarl.lang.core.Event)=>java.lang.Boolean,(java.lang.Object)=>void")
    @SyntheticMember
    public final void register(Object object) {
        this.register(object, $DEFAULT_VALUE$REGISTER_0, $DEFAULT_VALUE$REGISTER_1);
    }

    @DefaultValueUse(value="java.lang.Object,(io.sarl.lang.core.Event)=>java.lang.Boolean,(java.lang.Object)=>void")
    @SyntheticMember
    public final void register(Object object, Functions.Function1<? super Event, ? extends Boolean> function1) {
        this.register(object, function1, $DEFAULT_VALUE$REGISTER_1);
    }

    @DefaultValueUse(value="java.lang.Object,(io.sarl.lang.core.Event)=>java.lang.Boolean,(java.lang.Object)=>void")
    @SyntheticMember
    public final void register(Object object, Procedures.Procedure1<? super Object> procedure1) {
        this.register(object, $DEFAULT_VALUE$REGISTER_0, procedure1);
    }

    @DefaultValueUse(value="(java.lang.Object)=>void")
    @SyntheticMember
    public final void unregisterAll() {
        this.unregisterAll($DEFAULT_VALUE$UNREGISTERALL_0);
    }

    @DefaultValueUse(value="java.lang.Object,(java.lang.Object)=>void")
    @SyntheticMember
    public final void unregister(Object object) {
        this.unregister(object, $DEFAULT_VALUE$UNREGISTER_0);
    }

    @Pure
    @SyntheticMember
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        BehaviorGuardEvaluatorRegistry behaviorGuardEvaluatorRegistry = (BehaviorGuardEvaluatorRegistry)object;
        if (this.behaviorGuardEvaluators == null ? behaviorGuardEvaluatorRegistry.behaviorGuardEvaluators != null : !this.behaviorGuardEvaluators.equals(behaviorGuardEvaluatorRegistry.behaviorGuardEvaluators)) {
            return false;
        }
        if (behaviorGuardEvaluatorRegistry.active != this.active) {
            return false;
        }
        return super.equals(object);
    }

    @Pure
    @SyntheticMember
    public int hashCode() {
        int n = super.hashCode();
        n = 31 * n + (this.behaviorGuardEvaluators == null ? 0 : this.behaviorGuardEvaluators.hashCode());
        n = 31 * n + (this.active ? 1231 : 1237);
        return n;
    }

    @SarlSpecification(value="0.5")
    private static class EvaluatorCollectionFilteringIterator
    implements Iterator<BehaviorGuardEvaluator> {
        private final Iterator<BehaviorGuardEvaluator> iterator;
        private final Object subscriber;
        private BehaviorGuardEvaluator next;

        public EvaluatorCollectionFilteringIterator(Iterator<BehaviorGuardEvaluator> iterator, Object object) {
            this.iterator = iterator;
            this.subscriber = object;
            this.searchNext();
        }

        private void searchNext() {
            this.next = null;
            while (this.next == null && this.iterator.hasNext()) {
                boolean bl;
                BehaviorGuardEvaluator behaviorGuardEvaluator = this.iterator.next();
                Object object = behaviorGuardEvaluator.getTarget();
                boolean bl2 = bl = object == this.subscriber;
                if (!bl) continue;
                this.next = behaviorGuardEvaluator;
            }
        }

        @Override
        @Pure
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public BehaviorGuardEvaluator next() {
            BehaviorGuardEvaluator behaviorGuardEvaluator = this.next;
            this.searchNext();
            return behaviorGuardEvaluator;
        }

        @Pure
        @SyntheticMember
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            EvaluatorCollectionFilteringIterator evaluatorCollectionFilteringIterator = (EvaluatorCollectionFilteringIterator)object;
            if (this.iterator == null ? evaluatorCollectionFilteringIterator.iterator != null : !this.iterator.equals(evaluatorCollectionFilteringIterator.iterator)) {
                return false;
            }
            if (this.subscriber == null ? evaluatorCollectionFilteringIterator.subscriber != null : !this.subscriber.equals(evaluatorCollectionFilteringIterator.subscriber)) {
                return false;
            }
            if (this.next == null ? evaluatorCollectionFilteringIterator.next != null : !this.next.equals(evaluatorCollectionFilteringIterator.next)) {
                return false;
            }
            return super.equals(object);
        }

        @Pure
        @SyntheticMember
        public int hashCode() {
            int n = super.hashCode();
            n = 31 * n + (this.iterator == null ? 0 : this.iterator.hashCode());
            n = 31 * n + (this.subscriber == null ? 0 : this.subscriber.hashCode());
            n = 31 * n + (this.next == null ? 0 : this.next.hashCode());
            return n;
        }
    }

    @SarlSpecification(value="0.5")
    private static class EvaluatorCollectionIterator
    implements Iterator<BehaviorGuardEvaluator> {
        private final Map<Class<? extends Event>, Pair<Functions.Function1<? super Event, ? extends Boolean>, Set<BehaviorGuardEvaluator>>> behaviorGuardEvaluators;
        private final Event event;
        private final Iterator<Class<?>> eventTypeIterator;
        private final boolean skipSubscriberFiltering;
        private Iterator<BehaviorGuardEvaluator> evaluators;

        public EvaluatorCollectionIterator(Map<Class<? extends Event>, Pair<Functions.Function1<? super Event, ? extends Boolean>, Set<BehaviorGuardEvaluator>>> map, Event event, Iterator<Class<?>> iterator, boolean bl) {
            this.skipSubscriberFiltering = bl;
            this.behaviorGuardEvaluators = map;
            this.event = event;
            this.eventTypeIterator = iterator;
            this.searchNext();
        }

        private void searchNext() {
            while ((this.evaluators == null || !this.evaluators.hasNext()) && this.eventTypeIterator.hasNext()) {
                Class<?> clazz = this.eventTypeIterator.next();
                Pair<Functions.Function1<? super Event, ? extends Boolean>, Set<BehaviorGuardEvaluator>> pair = this.behaviorGuardEvaluators.get(clazz);
                boolean bl = this.isValidSubscriber(pair);
                if (!bl) continue;
                this.evaluators = pair.getValue().iterator();
            }
        }

        @Pure
        protected boolean isValidSubscriber(Pair<Functions.Function1<? super Event, ? extends Boolean>, Set<BehaviorGuardEvaluator>> pair) {
            if (pair != null && pair.getValue() != null) {
                return this.skipSubscriberFiltering || pair.getKey() == null || pair.getKey().apply(this.event) != false;
            }
            return false;
        }

        @Override
        @Pure
        public boolean hasNext() {
            return this.evaluators != null && this.evaluators.hasNext();
        }

        @Override
        public BehaviorGuardEvaluator next() {
            if (this.evaluators == null) {
                this.searchNext();
            }
            BehaviorGuardEvaluator behaviorGuardEvaluator = this.evaluators.next();
            this.searchNext();
            return behaviorGuardEvaluator;
        }

        @Pure
        @SyntheticMember
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            EvaluatorCollectionIterator evaluatorCollectionIterator = (EvaluatorCollectionIterator)object;
            if (this.behaviorGuardEvaluators == null ? evaluatorCollectionIterator.behaviorGuardEvaluators != null : !this.behaviorGuardEvaluators.equals(evaluatorCollectionIterator.behaviorGuardEvaluators)) {
                return false;
            }
            if (this.event == null ? evaluatorCollectionIterator.event != null : !this.event.equals(evaluatorCollectionIterator.event)) {
                return false;
            }
            if (this.eventTypeIterator == null ? evaluatorCollectionIterator.eventTypeIterator != null : !this.eventTypeIterator.equals(evaluatorCollectionIterator.eventTypeIterator)) {
                return false;
            }
            if (evaluatorCollectionIterator.skipSubscriberFiltering != this.skipSubscriberFiltering) {
                return false;
            }
            if (this.evaluators == null ? evaluatorCollectionIterator.evaluators != null : !this.evaluators.equals(evaluatorCollectionIterator.evaluators)) {
                return false;
            }
            return super.equals(object);
        }

        @Pure
        @SyntheticMember
        public int hashCode() {
            int n = super.hashCode();
            n = 31 * n + (this.behaviorGuardEvaluators == null ? 0 : this.behaviorGuardEvaluators.hashCode());
            n = 31 * n + (this.event == null ? 0 : this.event.hashCode());
            n = 31 * n + (this.eventTypeIterator == null ? 0 : this.eventTypeIterator.hashCode());
            n = 31 * n + (this.skipSubscriberFiltering ? 1231 : 1237);
            n = 31 * n + (this.evaluators == null ? 0 : this.evaluators.hashCode());
            return n;
        }
    }

    @SarlSpecification(value="0.5")
    private static class EvaluatorIterator
    implements Iterator<Pair<Class<? extends Event>, Collection<BehaviorGuardEvaluator>>> {
        private final Object listener;
        private final Iterator<Map.Entry<Class<? extends Event>, Collection<Method>>> iterator;

        public EvaluatorIterator(Object object) {
            Map map = BehaviorGuardEvaluatorRegistry.getAnnotatedMethodsPerEvent(object.getClass());
            this.iterator = map.entrySet().iterator();
            this.listener = object;
        }

        @Override
        @Pure
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Pair<Class<? extends Event>, Collection<BehaviorGuardEvaluator>> next() {
            Pair<Class<? extends Event>, Collection<BehaviorGuardEvaluator>> pair = null;
            Map.Entry<Class<? extends Event>, Collection<Method>> entry = this.iterator.next();
            Class<? extends Event> clazz = entry.getKey();
            Function function = method -> new BehaviorGuardEvaluator(this.listener, (Method)method);
            Collection collection = Collections2.transform(entry.getValue(), function);
            pair = new Pair<Class<? extends Event>, Collection<BehaviorGuardEvaluator>>(clazz, collection);
            return pair;
        }

        @Pure
        @SyntheticMember
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            EvaluatorIterator evaluatorIterator = (EvaluatorIterator)object;
            if (this.listener == null ? evaluatorIterator.listener != null : !this.listener.equals(evaluatorIterator.listener)) {
                return false;
            }
            if (this.iterator == null ? evaluatorIterator.iterator != null : !this.iterator.equals(evaluatorIterator.iterator)) {
                return false;
            }
            return super.equals(object);
        }

        @Pure
        @SyntheticMember
        public int hashCode() {
            int n = super.hashCode();
            n = 31 * n + (this.listener == null ? 0 : this.listener.hashCode());
            n = 31 * n + (this.iterator == null ? 0 : this.iterator.hashCode());
            return n;
        }
    }

    @SarlSpecification(value="0.5")
    private static final class MethodIdentifier
    implements Comparable<MethodIdentifier> {
        private final String name;
        private final List<Class<?>> parameterTypes;

        public MethodIdentifier(Method method, Class<?>[] classArray) {
            String string;
            Class<?> clazz = method.getDeclaringClass();
            String string2 = method.getName();
            this.name = string = clazz + string2;
            this.parameterTypes = Arrays.asList(classArray);
        }

        @Pure
        public int hashCode() {
            return Objects.hashCode(this.name, this.parameterTypes);
        }

        @Pure
        public boolean equals(Object object) {
            if (object instanceof MethodIdentifier) {
                return Objects.equal(this.name, ((MethodIdentifier)object).name) && Objects.equal(this.parameterTypes, ((MethodIdentifier)object).parameterTypes);
            }
            return false;
        }

        @Override
        public int compareTo(MethodIdentifier methodIdentifier) {
            if (methodIdentifier == null) {
                return -1;
            }
            int n = this.name.compareTo(methodIdentifier.name);
            if (n != 0) {
                return n;
            }
            int n2 = this.parameterTypes.size();
            int n3 = methodIdentifier.parameterTypes.size();
            int n4 = Integer.valueOf(n2).compareTo(n3);
            n = n4;
            if (n != 0) {
                return n;
            }
            Iterator<Class<?>> iterator = this.parameterTypes.iterator();
            Iterator<Class<?>> iterator2 = methodIdentifier.parameterTypes.iterator();
            while (iterator.hasNext()) {
                String string;
                String string2 = iterator.next().getName();
                int n5 = string2.compareTo(string = iterator2.next().getName());
                n = n5;
                if (n == 0) continue;
                return n;
            }
            return 0;
        }

        @Pure
        public String toString() {
            return this.name;
        }
    }
}

