/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.eventdispatching;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import io.sarl.eventdispatching.Messages;
import io.sarl.lang.annotation.SarlSpecification;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Collection;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Pure;

@SarlSpecification(value="0.5")
public final class BehaviorGuardEvaluator {
    private final Object target;
    private final Method method;

    public BehaviorGuardEvaluator(Object object, Method method) {
        this.target = object;
        this.method = method;
    }

    public Object evaluateGuard(Object object, Collection<Runnable> collection) {
        try {
            Object object2 = null;
            try {
                Object object3 = null;
                this.method.setAccessible(true);
                object2 = object3 = this.method.invoke(this.target, object, collection);
            }
            catch (Throwable throwable) {
                if (throwable instanceof IllegalArgumentException) {
                    IllegalArgumentException illegalArgumentException = (IllegalArgumentException)throwable;
                    String string = MessageFormat.format(Messages.BehaviorGuardEvaluator_0, object);
                    throw new Error(string, illegalArgumentException);
                }
                if (throwable instanceof IllegalAccessException) {
                    IllegalAccessException illegalAccessException = (IllegalAccessException)throwable;
                    String string = MessageFormat.format(Messages.BehaviorGuardEvaluator_1, object);
                    throw new Error(string, illegalAccessException);
                }
                if (throwable instanceof InvocationTargetException) {
                    InvocationTargetException invocationTargetException = (InvocationTargetException)throwable;
                    Throwable throwable2 = invocationTargetException.getCause();
                    if (throwable2 instanceof Error) {
                        Throwable throwable3 = invocationTargetException.getCause();
                        throw (Error)throwable3;
                    }
                    throw invocationTargetException;
                }
                throw Exceptions.sneakyThrow(throwable);
            }
            return object2;
        }
        catch (Throwable throwable) {
            throw Exceptions.sneakyThrow(throwable);
        }
    }

    @Pure
    public Object getTarget() {
        return this.target;
    }

    @Pure
    public int hashCode() {
        int n = this.method.hashCode();
        int n2 = 31 + n;
        int n3 = n2 * 31;
        int n4 = System.identityHashCode(this.target);
        return n3 + n4;
    }

    @Pure
    public boolean equals(Object object) {
        if (object instanceof BehaviorGuardEvaluator) {
            return this.target == ((BehaviorGuardEvaluator)object).target && Objects.equal(this.method, ((BehaviorGuardEvaluator)object).method);
        }
        return false;
    }

    @Pure
    public String toString() {
        String string = null;
        string = this.method == null ? Strings.emptyToNull(null) : this.method.getName();
        return string;
    }
}

