/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.core;

import io.sarl.core.AgentKilled;
import io.sarl.core.AgentSpawned;
import io.sarl.core.Destroy;
import io.sarl.lang.annotation.EarlyExit;
import io.sarl.lang.annotation.FiredEvent;
import io.sarl.lang.annotation.SarlSpecification;
import io.sarl.lang.core.Agent;
import io.sarl.lang.core.AgentContext;
import io.sarl.lang.core.AgentTrait;
import io.sarl.lang.core.Capacity;
import java.util.Collection;
import java.util.UUID;

@SarlSpecification(value="0.5")
public interface Lifecycle
extends Capacity {
    @FiredEvent(value={AgentSpawned.class})
    public UUID spawn(Class<? extends Agent> var1, Object ... var2);

    @FiredEvent(value={AgentSpawned.class})
    public Collection<UUID> spawn(int var1, Class<? extends Agent> var2, Object ... var3);

    @FiredEvent(value={AgentSpawned.class})
    public UUID spawnInContext(Class<? extends Agent> var1, AgentContext var2, Object ... var3);

    @FiredEvent(value={AgentSpawned.class})
    public Collection<UUID> spawnInContext(int var1, Class<? extends Agent> var2, AgentContext var3, Object ... var4);

    @FiredEvent(value={AgentSpawned.class})
    public UUID spawnInContextWithID(Class<? extends Agent> var1, UUID var2, AgentContext var3, Object ... var4);

    @FiredEvent(value={AgentKilled.class, Destroy.class})
    @EarlyExit
    public void killMe();

    public static class ContextAwareCapacityWrapper<C extends Lifecycle>
    extends Capacity.ContextAwareCapacityWrapper<C>
    implements Lifecycle {
        public ContextAwareCapacityWrapper(C c, AgentTrait agentTrait) {
            super(c, agentTrait);
        }

        @Override
        public UUID spawn(Class<? extends Agent> clazz, Object ... objectArray) {
            try {
                this.ensureCallerInLocalThread();
                UUID uUID = ((Lifecycle)this.capacity).spawn(clazz, objectArray);
                return uUID;
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        @Override
        public Collection<UUID> spawn(int n, Class<? extends Agent> clazz, Object ... objectArray) {
            try {
                this.ensureCallerInLocalThread();
                Collection<UUID> collection = ((Lifecycle)this.capacity).spawn(n, clazz, objectArray);
                return collection;
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        @Override
        public UUID spawnInContext(Class<? extends Agent> clazz, AgentContext agentContext, Object ... objectArray) {
            try {
                this.ensureCallerInLocalThread();
                UUID uUID = ((Lifecycle)this.capacity).spawnInContext(clazz, agentContext, objectArray);
                return uUID;
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        @Override
        public Collection<UUID> spawnInContext(int n, Class<? extends Agent> clazz, AgentContext agentContext, Object ... objectArray) {
            try {
                this.ensureCallerInLocalThread();
                Collection<UUID> collection = ((Lifecycle)this.capacity).spawnInContext(n, clazz, agentContext, objectArray);
                return collection;
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        @Override
        public UUID spawnInContextWithID(Class<? extends Agent> clazz, UUID uUID, AgentContext agentContext, Object ... objectArray) {
            try {
                this.ensureCallerInLocalThread();
                UUID uUID2 = ((Lifecycle)this.capacity).spawnInContextWithID(clazz, uUID, agentContext, objectArray);
                return uUID2;
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        @Override
        public void killMe() {
            try {
                this.ensureCallerInLocalThread();
                ((Lifecycle)this.capacity).killMe();
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }
    }
}

