/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.core;

import io.sarl.core.ContextJoined;
import io.sarl.core.ContextLeft;
import io.sarl.core.MemberJoined;
import io.sarl.core.MemberLeft;
import io.sarl.lang.annotation.FiredEvent;
import io.sarl.lang.annotation.SarlSpecification;
import io.sarl.lang.core.AgentContext;
import io.sarl.lang.core.AgentTrait;
import io.sarl.lang.core.Capacity;
import io.sarl.lang.core.Event;
import io.sarl.lang.core.Space;
import io.sarl.lang.core.SpaceID;
import io.sarl.lang.util.SynchronizedCollection;
import java.util.UUID;
import org.eclipse.xtext.xbase.lib.Pure;

@SarlSpecification(value="0.5")
public interface ExternalContextAccess
extends Capacity {
    @Pure
    public SynchronizedCollection<AgentContext> getAllContexts();

    @Pure
    public AgentContext getContext(UUID var1);

    @FiredEvent(value={ContextJoined.class, MemberJoined.class})
    public void join(UUID var1, UUID var2);

    @FiredEvent(value={ContextLeft.class, MemberLeft.class})
    public void leave(UUID var1);

    @Pure
    public boolean isInSpace(Event var1, Space var2);

    @Pure
    public boolean isInSpace(Event var1, SpaceID var2);

    @Pure
    public boolean isInSpace(Event var1, UUID var2);

    public static class ContextAwareCapacityWrapper<C extends ExternalContextAccess>
    extends Capacity.ContextAwareCapacityWrapper<C>
    implements ExternalContextAccess {
        public ContextAwareCapacityWrapper(C c, AgentTrait agentTrait) {
            super(c, agentTrait);
        }

        @Override
        public SynchronizedCollection<AgentContext> getAllContexts() {
            try {
                this.ensureCallerInLocalThread();
                SynchronizedCollection<AgentContext> synchronizedCollection = ((ExternalContextAccess)this.capacity).getAllContexts();
                return synchronizedCollection;
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        @Override
        public AgentContext getContext(UUID uUID) {
            try {
                this.ensureCallerInLocalThread();
                AgentContext agentContext = ((ExternalContextAccess)this.capacity).getContext(uUID);
                return agentContext;
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        @Override
        public void join(UUID uUID, UUID uUID2) {
            try {
                this.ensureCallerInLocalThread();
                ((ExternalContextAccess)this.capacity).join(uUID, uUID2);
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        @Override
        public void leave(UUID uUID) {
            try {
                this.ensureCallerInLocalThread();
                ((ExternalContextAccess)this.capacity).leave(uUID);
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        @Override
        public boolean isInSpace(Event event, Space space) {
            try {
                this.ensureCallerInLocalThread();
                boolean bl = ((ExternalContextAccess)this.capacity).isInSpace(event, space);
                return bl;
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        @Override
        public boolean isInSpace(Event event, SpaceID spaceID) {
            try {
                this.ensureCallerInLocalThread();
                boolean bl = ((ExternalContextAccess)this.capacity).isInSpace(event, spaceID);
                return bl;
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        @Override
        public boolean isInSpace(Event event, UUID uUID) {
            try {
                this.ensureCallerInLocalThread();
                boolean bl = ((ExternalContextAccess)this.capacity).isInSpace(event, uUID);
                return bl;
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }
    }
}

