/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.core;

import io.sarl.lang.annotation.DefaultValue;
import io.sarl.lang.annotation.DefaultValueSource;
import io.sarl.lang.annotation.DefaultValueUse;
import io.sarl.lang.annotation.SarlSourceCode;
import io.sarl.lang.annotation.SarlSpecification;
import io.sarl.lang.annotation.SyntheticMember;
import io.sarl.lang.core.Address;
import io.sarl.lang.core.AgentTrait;
import io.sarl.lang.core.Behavior;
import io.sarl.lang.core.Capacity;
import io.sarl.lang.core.Event;
import io.sarl.lang.core.EventListener;
import io.sarl.lang.core.Scope;
import java.util.Collection;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.Pure;

@SarlSpecification(value="0.5")
public interface Behaviors
extends Capacity {
    @SyntheticMember
    @SarlSourceCode(value="null")
    public static final Functions.Function1<? super Event, ? extends Boolean> $DEFAULT_VALUE$REGISTERBEHAVIOR_0 = null;
    @SyntheticMember
    @SarlSourceCode(value="null")
    public static final Scope<Address> $DEFAULT_VALUE$WAKE_0 = null;

    public boolean hasRegisteredBehavior();

    public Collection<Behavior> getRegisteredBehaviors();

    @DefaultValueSource
    public Behavior registerBehavior(Behavior var1, @DefaultValue(value="io.sarl.core.Behaviors#REGISTERBEHAVIOR_0") Functions.Function1<? super Event, ? extends Boolean> var2);

    public Behavior unregisterBehavior(Behavior var1);

    @DefaultValueSource
    public void wake(Event var1, @DefaultValue(value="io.sarl.core.Behaviors#WAKE_0") Scope<Address> var2);

    @Pure
    public EventListener asEventListener();

    @DefaultValueUse(value="io.sarl.lang.core.Behavior,(io.sarl.lang.core.Event)=>boolean")
    @SyntheticMember
    default public Behavior registerBehavior(Behavior behavior) {
        return this.registerBehavior(behavior, $DEFAULT_VALUE$REGISTERBEHAVIOR_0);
    }

    @DefaultValueUse(value="io.sarl.lang.core.Event,io.sarl.lang.core.Scope<io.sarl.lang.core.Address>")
    @SyntheticMember
    default public void wake(Event event) {
        this.wake(event, $DEFAULT_VALUE$WAKE_0);
    }

    public static class ContextAwareCapacityWrapper<C extends Behaviors>
    extends Capacity.ContextAwareCapacityWrapper<C>
    implements Behaviors {
        public ContextAwareCapacityWrapper(C c, AgentTrait agentTrait) {
            super(c, agentTrait);
        }

        @Override
        public boolean hasRegisteredBehavior() {
            try {
                this.ensureCallerInLocalThread();
                boolean bl = ((Behaviors)this.capacity).hasRegisteredBehavior();
                return bl;
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        @Override
        public Collection<Behavior> getRegisteredBehaviors() {
            try {
                this.ensureCallerInLocalThread();
                Collection<Behavior> collection = ((Behaviors)this.capacity).getRegisteredBehaviors();
                return collection;
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        @Override
        public Behavior registerBehavior(Behavior behavior, Functions.Function1<? super Event, ? extends Boolean> function1) {
            try {
                this.ensureCallerInLocalThread();
                Behavior behavior2 = ((Behaviors)this.capacity).registerBehavior(behavior, function1);
                return behavior2;
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        @Override
        public Behavior unregisterBehavior(Behavior behavior) {
            try {
                this.ensureCallerInLocalThread();
                Behavior behavior2 = ((Behaviors)this.capacity).unregisterBehavior(behavior);
                return behavior2;
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        @Override
        public void wake(Event event, Scope<Address> scope) {
            try {
                this.ensureCallerInLocalThread();
                ((Behaviors)this.capacity).wake(event, scope);
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        @Override
        public EventListener asEventListener() {
            try {
                this.ensureCallerInLocalThread();
                EventListener eventListener = ((Behaviors)this.capacity).asEventListener();
                return eventListener;
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        @Override
        public Behavior registerBehavior(Behavior behavior) {
            try {
                this.ensureCallerInLocalThread();
                Behavior behavior2 = ((Behaviors)this.capacity).registerBehavior(behavior);
                return behavior2;
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        @Override
        public void wake(Event event) {
            try {
                this.ensureCallerInLocalThread();
                ((Behaviors)this.capacity).wake(event);
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }
    }
}

