/*
 * Decompiled with CFR 0.152.
 */
package io.janusproject.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.EventListener;

public class ListenerCollection<L extends EventListener> {
    private static final Object[] NULL = new Object[0];
    protected transient Object[] listeners = NULL;

    public boolean isEmpty() {
        return this.listeners == NULL;
    }

    public void clear() {
        this.listeners = NULL;
    }

    public Object[] getListenerList() {
        return this.listeners;
    }

    public <T extends EventListener> T[] getListeners(Class<T> type) {
        Object[] iListeners = this.listeners;
        int listenerCount = ListenerCollection.getListenerCount(iListeners, type);
        EventListener[] result = (EventListener[])Array.newInstance(type, listenerCount);
        int j = 0;
        int i = iListeners.length - 2;
        while (i >= 0) {
            if (iListeners[i] == type) {
                result[j++] = (EventListener)type.cast(iListeners[i + 1]);
            }
            i -= 2;
        }
        return result;
    }

    public int size() {
        return this.listeners.length / 2;
    }

    public synchronized int getListenerCount(Class<?> type) {
        return ListenerCollection.getListenerCount(this.listeners, type);
    }

    private static int getListenerCount(Object[] list, Class<?> type) {
        int count = 0;
        int i = 0;
        while (i < list.length) {
            if (type == (Class)list[i]) {
                ++count;
            }
            i += 2;
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends EventListener> void add(Class<T> type, T listener) {
        assert (listener != null);
        ListenerCollection listenerCollection = this;
        synchronized (listenerCollection) {
            Object[] ilisteners = this.listeners;
            if (ilisteners == NULL) {
                ilisteners = new Object[]{type, listener};
            } else {
                int i = ilisteners.length;
                Object[] tmp = new Object[i + 2];
                System.arraycopy(ilisteners, 0, tmp, 0, i);
                tmp[i] = type;
                tmp[i + 1] = listener;
                ilisteners = tmp;
            }
            this.listeners = ilisteners;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends EventListener> void remove(Class<T> type, T listener) {
        assert (listener != null);
        ListenerCollection listenerCollection = this;
        synchronized (listenerCollection) {
            Object[] ilisteners = this.listeners;
            int index = -1;
            int i = ilisteners.length - 2;
            while (i >= 0) {
                if (ilisteners[i] == type && ilisteners[i + 1].equals(listener)) {
                    index = i;
                    break;
                }
                i -= 2;
            }
            if (index != -1) {
                Object[] tmp = new Object[ilisteners.length - 2];
                System.arraycopy(ilisteners, 0, tmp, 0, index);
                if (index < tmp.length) {
                    System.arraycopy(ilisteners, index + 2, tmp, index, tmp.length - index);
                }
                ilisteners = tmp.length == 0 ? NULL : tmp;
            }
            this.listeners = ilisteners;
        }
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        Object[] lList = this.listeners;
        stream.defaultWriteObject();
        int i = 0;
        while (i < lList.length) {
            Class t = (Class)lList[i];
            EventListener listener = (EventListener)lList[i + 1];
            if (listener != null && listener instanceof Serializable) {
                stream.writeObject(t.getName());
                stream.writeObject(listener);
            }
            i += 2;
        }
        stream.writeObject(null);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        Object listenerTypeOrNull;
        this.listeners = NULL;
        stream.defaultReadObject();
        while ((listenerTypeOrNull = stream.readObject()) != null) {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            EventListener listener = (EventListener)stream.readObject();
            this.add(Class.forName((String)listenerTypeOrNull, true, cl), listener);
        }
    }

    public String toString() {
        Object[] lList = this.listeners;
        String txt = "EventListenerList: ";
        txt = String.valueOf(txt) + lList.length / 2 + " listeners: ";
        int i = 0;
        while (i <= lList.length - 2) {
            txt = String.valueOf(txt) + " type " + ((Class)lList[i]).getName();
            txt = String.valueOf(txt) + " listener " + lList[i + 1];
            i += 2;
        }
        return txt;
    }
}

