/*
 * Decompiled with CFR 0.152.
 */
package io.janusproject.services.network;

import io.janusproject.services.network.NetworkConfig;
import java.io.IOError;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.UUID;

public final class NetworkUtil {
    private NetworkUtil() {
    }

    public static boolean isConnectedHost() {
        return NetworkUtil.getPrimaryAddress() != null;
    }

    public static InetAddress getPrimaryAddress() {
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            if (interfaces != null) {
                while (interfaces.hasMoreElements()) {
                    NetworkInterface inter = interfaces.nextElement();
                    Enumeration<InetAddress> addrs = inter.getInetAddresses();
                    if (addrs == null) continue;
                    while (addrs.hasMoreElements()) {
                        InetAddress adr = addrs.nextElement();
                        if (adr == null || adr.isLoopbackAddress() || !(adr instanceof Inet4Address)) continue;
                        return adr;
                    }
                }
            }
        }
        catch (SocketException socketException) {}
        return null;
    }

    public static InetAddress getLoopbackAddress() {
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            if (interfaces != null) {
                while (interfaces.hasMoreElements()) {
                    NetworkInterface inter = interfaces.nextElement();
                    Enumeration<InetAddress> addrs = inter.getInetAddresses();
                    if (addrs == null) continue;
                    while (addrs.hasMoreElements()) {
                        InetAddress adr = addrs.nextElement();
                        if (adr == null || !adr.isLoopbackAddress() || !(adr instanceof Inet4Address)) continue;
                        return adr;
                    }
                }
            }
        }
        catch (SocketException socketException) {}
        return null;
    }

    public static byte[] toByteArray(UUID id) {
        return id.toString().getBytes(NetworkConfig.getStringEncodingCharset());
    }

    public static UUID fromByteArray(byte[] id) {
        return UUID.fromString(new String(id, NetworkConfig.getStringEncodingCharset()));
    }

    public static URI toURI(String uri) throws URISyntaxException {
        URI u = new URI(uri);
        String adr = u.getAuthority();
        if (adr == null) {
            adr = u.getPath();
        }
        if (adr != null && adr.endsWith(":*")) {
            return new URI(u.getScheme(), u.getUserInfo(), adr.substring(0, adr.length() - 2), -1, null, u.getQuery(), u.getFragment());
        }
        return u;
    }

    public static URI toURI(InetAddress adr) {
        try {
            return new URI("tcp", adr.getHostAddress(), null, null);
        }
        catch (URISyntaxException e) {
            throw new IOError(e);
        }
    }

    public static URI toURI(InetSocketAddress adr) {
        return NetworkUtil.toURI(adr.getAddress(), adr.getPort());
    }

    public static URI toURI(InetAddress adr, int port) {
        try {
            return new URI("tcp", null, adr.getHostAddress(), port, null, null, null);
        }
        catch (URISyntaxException e) {
            throw new IOError(e);
        }
    }

    public static InetAddress toInetAddress(URI uri) {
        try {
            String protocol = uri.getScheme();
            String address = uri.getHost();
            if ("tcp".equalsIgnoreCase(protocol)) {
                return InetAddress.getByName(address);
            }
            throw new IllegalArgumentException(uri.toString());
        }
        catch (UnknownHostException e) {
            throw new IOError(e);
        }
    }

    public static InetSocketAddress toInetSocketAddress(URI uri) {
        InetAddress adr = NetworkUtil.toInetAddress(uri);
        int port = uri.getPort();
        if (port <= 0) {
            throw new IllegalArgumentException(uri.toString());
        }
        return new InetSocketAddress(adr, port);
    }
}

