/*
 * Decompiled with CFR 0.152.
 */
package io.janusproject.modules.hazelcast;

import com.google.common.util.concurrent.Service;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.name.Named;
import com.hazelcast.config.Config;
import com.hazelcast.config.MulticastConfig;
import com.hazelcast.config.NetworkConfig;
import com.hazelcast.config.SerializerConfig;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import io.janusproject.JanusConfig;
import io.janusproject.kernel.services.hazelcast.HazelcastDistributedDataStructureService;
import io.janusproject.kernel.services.hazelcast.HazelcastInfrastructureService;
import io.janusproject.kernel.services.hazelcast.HazelcastKernelDiscoveryService;
import io.janusproject.modules.hazelcast.AddressSerializer;
import io.janusproject.modules.hazelcast.HazelcastKernelLoggerFactory;
import io.janusproject.modules.hazelcast.SpaceIDSerializer;
import io.janusproject.services.distributeddata.DistributedDataStructureService;
import io.janusproject.services.kerneldiscovery.KernelDiscoveryService;
import io.janusproject.services.logging.LogService;
import io.janusproject.services.network.NetworkUtil;
import io.sarl.lang.core.Address;
import io.sarl.lang.core.SpaceID;
import java.net.InetAddress;
import java.net.URI;

public class HazelcastModule
extends AbstractModule {
    @Override
    protected void configure() {
        SerializerConfig sc = new SerializerConfig();
        sc.setTypeClass(SpaceID.class);
        sc.setImplementation(new SpaceIDSerializer());
        SerializerConfig sc2 = new SerializerConfig();
        sc2.setTypeClass(Address.class);
        sc2.setImplementation(new AddressSerializer());
        Config hazelcastConfig = new Config();
        hazelcastConfig.getSerializationConfig().addSerializerConfig(sc);
        hazelcastConfig.getSerializationConfig().addSerializerConfig(sc2);
        this.bind(Config.class).toInstance(hazelcastConfig);
        String factory = JanusConfig.getSystemProperty("hazelcast.logging.class", JanusConfig.HAZELCAST_LOGGER_FACTORY_VALUE);
        assert (factory != null && !factory.isEmpty());
        System.setProperty("hazelcast.logging.class", factory);
        Multibinder<Service> serviceSetBinder = Multibinder.newSetBinder(this.binder(), Service.class);
        serviceSetBinder.addBinding().to(HazelcastInfrastructureService.class).in(Singleton.class);
        this.bind(DistributedDataStructureService.class).to(HazelcastDistributedDataStructureService.class).in(Singleton.class);
        this.bind(KernelDiscoveryService.class).to(HazelcastKernelDiscoveryService.class).in(Singleton.class);
    }

    @Provides
    @Singleton
    private static HazelcastInstance createHazelcastInstance(Config config, LogService logService, @Named(value="network.pub.uri") URI uri) {
        assert (uri != null);
        boolean enableMulticast = true;
        InetAddress adr = null;
        if (JanusConfig.getSystemPropertyAsBoolean("janus.network.offline", false)) {
            adr = NetworkUtil.getLoopbackAddress();
            enableMulticast = false;
        } else {
            try {
                adr = NetworkUtil.toInetAddress(uri);
            }
            catch (Throwable e) {
                logService.error("INVALID_PUB_URI", e);
            }
        }
        if (adr == null) {
            adr = !NetworkUtil.isConnectedHost() ? NetworkUtil.getLoopbackAddress() : NetworkUtil.getPrimaryAddress();
        }
        assert (adr != null);
        String hostname = adr.getHostAddress();
        config.setProperty("hazelcast.local.localAddress", hostname);
        NetworkConfig networkConfig = config.getNetworkConfig();
        MulticastConfig multicastConfig = networkConfig.getJoin().getMulticastConfig();
        if (enableMulticast) {
            if (adr.isLoopbackAddress()) {
                multicastConfig.setLoopbackModeEnabled(true);
            }
        } else {
            multicastConfig.setEnabled(false);
        }
        HazelcastKernelLoggerFactory.setLogService(logService);
        return Hazelcast.newHazelcastInstance(config);
    }
}

