/*
 * Decompiled with CFR 0.152.
 */
package io.janusproject.modules.executors;

import com.google.inject.AbstractModule;
import com.google.inject.Singleton;
import io.janusproject.JanusConfig;
import io.janusproject.kernel.services.jdk.executors.JdkExecutorService;
import io.janusproject.kernel.services.jdk.executors.JdkRejectedExecutionHandler;
import io.janusproject.kernel.services.jdk.executors.JdkUncaughtExceptionHandler;
import io.janusproject.services.executor.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Provider;

public class JdkExecutorModule
extends AbstractModule {
    @Override
    protected void configure() {
        this.bind(Thread.UncaughtExceptionHandler.class).to(JdkUncaughtExceptionHandler.class).in(Singleton.class);
        this.bind(RejectedExecutionHandler.class).to(JdkRejectedExecutionHandler.class).in(Singleton.class);
        this.bind(java.util.concurrent.ExecutorService.class).toProvider(ExecutorProvider.class).in(Singleton.class);
        this.bind(ScheduledExecutorService.class).toProvider(ScheduledExecutorProvider.class).in(Singleton.class);
        this.bind(ExecutorService.class).to(JdkExecutorService.class).in(Singleton.class);
    }

    public static class ExecutorProvider
    implements Provider<java.util.concurrent.ExecutorService> {
        private RejectedExecutionHandler rejectedExecutionHandler;

        @Inject
        public void setRejectedExecutionHandler(RejectedExecutionHandler handler) {
            this.rejectedExecutionHandler = handler;
        }

        @Override
        public java.util.concurrent.ExecutorService get() {
            int minPoolSize = JanusConfig.getSystemPropertyAsInteger("janus.executors.threads.min", 16);
            int maxPoolSize = JanusConfig.getSystemPropertyAsInteger("janus.executors.threads.max", 512);
            int keepAliveDuration = JanusConfig.getSystemPropertyAsInteger("janus.executors.threads.keepAliveDuration", 0);
            ThreadPoolExecutor executor = new ThreadPoolExecutor(Math.max(0, Math.min(minPoolSize, maxPoolSize)), Math.max(1, Math.max(minPoolSize, maxPoolSize)), keepAliveDuration, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
            if (this.rejectedExecutionHandler != null && executor instanceof ThreadPoolExecutor) {
                executor.setRejectedExecutionHandler(this.rejectedExecutionHandler);
            }
            return executor;
        }
    }

    public static class ScheduledExecutorProvider
    implements Provider<ScheduledExecutorService> {
        private RejectedExecutionHandler rejectedExecutionHandler;

        @Inject
        public void setRejectedExecutionHandler(RejectedExecutionHandler handler) {
            this.rejectedExecutionHandler = handler;
        }

        @Override
        public ScheduledExecutorService get() {
            int minPoolSize = JanusConfig.getSystemPropertyAsInteger("janus.executors.threads.min", 16);
            int maxPoolSize = JanusConfig.getSystemPropertyAsInteger("janus.executors.threads.max", 512);
            ScheduledExecutorService executor = Executors.newScheduledThreadPool(Math.max(1, Math.min(minPoolSize, maxPoolSize)));
            if (this.rejectedExecutionHandler != null && executor instanceof ThreadPoolExecutor) {
                ((ThreadPoolExecutor)((Object)executor)).setRejectedExecutionHandler(this.rejectedExecutionHandler);
            }
            return executor;
        }
    }
}

