/*
 * Decompiled with CFR 0.152.
 */
package io.janusproject.modules;

import com.google.inject.AbstractModule;
import io.janusproject.JanusConfig;
import io.janusproject.modules.BootModule;
import io.janusproject.modules.StandardCoreModule;
import io.janusproject.modules.eventserial.NetworkEventModule;
import io.janusproject.modules.hazelcast.HazelcastModule;
import io.janusproject.modules.kernel.LocalDistributedDataStructureServiceModule;
import io.janusproject.modules.kernel.LocalInfrastructureServiceModule;
import io.janusproject.modules.kernel.LocalKernelDiscoveryServiceModule;
import io.janusproject.modules.nonetwork.NoNetworkModule;
import io.janusproject.modules.zeromq.ZeroMQNetworkModule;

public class StandardJanusPlatformModule
extends AbstractModule {
    @Override
    protected void configure() {
        boolean isNetworkEnabled = !JanusConfig.getSystemPropertyAsBoolean("janus.network.offline", false);
        this.install(new BootModule());
        if (isNetworkEnabled) {
            this.install(new HazelcastModule());
        } else {
            this.install(new LocalInfrastructureServiceModule());
            this.install(new LocalDistributedDataStructureServiceModule());
            this.install(new LocalKernelDiscoveryServiceModule());
        }
        this.install(new StandardCoreModule());
        if (isNetworkEnabled) {
            this.install(new NetworkEventModule());
            this.install(new ZeroMQNetworkModule());
        } else {
            this.install(new NoNetworkModule());
        }
    }
}

