/*
 * Decompiled with CFR 0.152.
 */
package io.janusproject.modules;

import com.google.common.base.Strings;
import com.google.inject.AbstractModule;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.Provides;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import io.janusproject.JanusConfig;
import io.janusproject.services.network.NetworkUtil;
import java.io.IOError;
import java.lang.annotation.Annotation;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.UUID;

public class BootModule
extends AbstractModule {
    @Override
    protected void configure() {
        boolean foundPubUri = false;
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            String name = entry.getKey().toString();
            this.bind(Key.get(String.class, (Annotation)Names.named(name))).toInstance(entry.getValue().toString());
            if (!"network.pub.uri".equals(name)) continue;
            foundPubUri = true;
        }
        if (!foundPubUri) {
            this.bind(Key.get(String.class, (Annotation)Names.named("network.pub.uri"))).toProvider(PublicURIProvider.class);
        }
    }

    @Provides
    @Named(value="janus.context.id")
    private static UUID getContextID() {
        String str = JanusConfig.getSystemProperty("janus.context.id");
        if (Strings.isNullOrEmpty(str)) {
            str = JanusConfig.getSystemProperty("janus.context.id.boot");
            Boolean v = Strings.isNullOrEmpty(str) ? JanusConfig.BOOT_DEFAULT_CONTEXT_ID_VALUE : Boolean.valueOf(Boolean.parseBoolean(str));
            if (v.booleanValue()) {
                String bootClassname = JanusConfig.getSystemProperty("janus.boot.agent");
                str = UUID.nameUUIDFromBytes(bootClassname.getBytes()).toString();
            } else {
                str = JanusConfig.getSystemProperty("janus.context.id.random");
                v = Strings.isNullOrEmpty(str) ? JanusConfig.RANDOM_DEFAULT_CONTEXT_ID_VALUE : Boolean.valueOf(Boolean.parseBoolean(str));
                str = v != false ? UUID.randomUUID().toString() : "2c38fb7f-f363-4f6e-877b-110b1f07cc77";
            }
            System.setProperty("janus.context.id", str);
        }
        assert (!Strings.isNullOrEmpty(str));
        return UUID.fromString(str);
    }

    @Provides
    @Named(value="janus.context.space.id")
    private static UUID getSpaceID() {
        String v = JanusConfig.getSystemProperty("janus.context.space.id", "7ba8885d-545b-445a-a0e9-b655bc15ebe0");
        return UUID.fromString(v);
    }

    @Provides
    @Named(value="network.pub.uri")
    private static URI getPubURIAsURI() {
        String v = BootModule.getPUBURIAsString();
        try {
            return NetworkUtil.toURI(v);
        }
        catch (URISyntaxException e) {
            throw new IOError(e);
        }
    }

    private static String getPUBURIAsString() {
        String pubUri = JanusConfig.getSystemProperty("network.pub.uri");
        if (pubUri == null || pubUri.isEmpty()) {
            InetAddress a = NetworkUtil.getPrimaryAddress();
            if (a == null) {
                a = NetworkUtil.getLoopbackAddress();
            }
            if (a != null) {
                pubUri = NetworkUtil.toURI(a, -1).toString();
                System.setProperty("network.pub.uri", pubUri);
            }
        }
        return pubUri;
    }

    private static class PublicURIProvider
    implements Provider<String> {
        private PublicURIProvider() {
        }

        @Override
        public String get() {
            return BootModule.getPUBURIAsString();
        }
    }
}

