/*
 * Decompiled with CFR 0.152.
 */
package io.janusproject.kernel.space;

import com.google.inject.Inject;
import io.janusproject.kernel.repository.UniqueAddressParticipantRepository;
import io.janusproject.kernel.space.Messages;
import io.janusproject.kernel.space.SpaceBase;
import io.janusproject.services.distributeddata.DistributedDataStructureService;
import io.janusproject.services.executor.ExecutorService;
import io.janusproject.services.logging.LogService;
import io.janusproject.services.network.NetworkService;
import io.sarl.lang.core.Address;
import io.sarl.lang.core.Event;
import io.sarl.lang.core.EventListener;
import io.sarl.lang.core.Scope;
import io.sarl.lang.core.SpaceID;
import io.sarl.lang.util.SynchronizedCollection;
import io.sarl.lang.util.SynchronizedSet;
import io.sarl.util.Collections3;
import io.sarl.util.Scopes;
import java.util.UUID;

public abstract class AbstractEventSpace
extends SpaceBase {
    @Inject
    protected LogService logger;
    @Inject
    protected ExecutorService executorService;
    @Inject
    private NetworkService network;
    private final UniqueAddressParticipantRepository<Address> participants;

    public AbstractEventSpace(SpaceID id, DistributedDataStructureService factory) {
        super(id);
        this.participants = new UniqueAddressParticipantRepository(String.valueOf(this.getSpaceID().getID().toString()) + "-participants", factory);
    }

    protected UniqueAddressParticipantRepository<Address> getParticipantInternalDataStructure() {
        return this.participants;
    }

    public final Address getAddress(EventListener entity) {
        return this.getAddress(entity.getID());
    }

    public Address getAddress(UUID id) {
        return this.getParticipantInternalDataStructure().getAddress(id);
    }

    public final void emit(Event event, Scope<Address> scope) {
        assert (event != null);
        assert (event.getSource() != null) : "Every event must have a source";
        assert (this.getSpaceID().equals(event.getSource().getSpaceId())) : "The source address must belong to this space";
        try {
            Scope<Object> scopeInstance = scope == null ? Scopes.allParticipants() : scope;
            this.network.publish(scopeInstance, event);
            this.doEmit(event, scopeInstance);
        }
        catch (Throwable e) {
            this.logger.error(Messages.AbstractEventSpace_0, event, scope, e);
        }
    }

    public final void emit(Event event) {
        this.emit(event, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doEmit(Event event, Scope<? super Address> scope) {
        assert (scope != null);
        assert (event != null);
        UniqueAddressParticipantRepository<Address> particips = this.getParticipantInternalDataStructure();
        SynchronizedCollection<EventListener> listeners = particips.getListeners();
        Object object = listeners.mutex();
        synchronized (object) {
            for (EventListener agent : listeners) {
                if (!scope.matches(this.getAddress(agent))) continue;
                this.executorService.submit(new AsyncRunner(agent, event));
            }
        }
    }

    @Override
    public SynchronizedSet<UUID> getParticipants() {
        return Collections3.unmodifiableSynchronizedSet(this.getParticipantInternalDataStructure().getParticipantIDs());
    }

    public String toString() {
        return this.getSpaceID().toString();
    }

    @Override
    public void eventReceived(SpaceID space, Scope<?> scope, Event event) {
        try {
            this.doEmit(event, scope);
        }
        catch (Exception e) {
            this.logger.error(Messages.AbstractEventSpace_1, e);
        }
    }

    private static class AsyncRunner
    implements Runnable {
        private final EventListener agent;
        private final Event event;

        AsyncRunner(EventListener agent, Event event) {
            this.agent = agent;
            this.event = event;
        }

        @Override
        public void run() {
            this.agent.receiveEvent(this.event);
        }

        public String toString() {
            return "[agent=" + this.agent + "; event=" + this.event + "]";
        }
    }
}

