/*
 * Decompiled with CFR 0.152.
 */
package io.janusproject.kernel.services.jdk.spawn;

import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.Service;
import com.google.inject.AbstractModule;
import com.google.inject.Injector;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import io.janusproject.kernel.bic.BuiltinCapacityUtil;
import io.janusproject.kernel.services.jdk.spawn.Messages;
import io.janusproject.services.AbstractDependentService;
import io.janusproject.services.contextspace.ContextSpaceService;
import io.janusproject.services.executor.ExecutorService;
import io.janusproject.services.logging.LogService;
import io.janusproject.services.spawn.KernelAgentSpawnListener;
import io.janusproject.services.spawn.SpawnService;
import io.janusproject.services.spawn.SpawnServiceListener;
import io.janusproject.util.ListenerCollection;
import io.sarl.core.AgentKilled;
import io.sarl.core.AgentSpawned;
import io.sarl.core.Logging;
import io.sarl.lang.core.Address;
import io.sarl.lang.core.Agent;
import io.sarl.lang.core.AgentContext;
import io.sarl.lang.core.BuiltinCapacitiesProvider;
import io.sarl.lang.core.EventSpace;
import io.sarl.lang.core.Skill;
import io.sarl.lang.util.SynchronizedCollection;
import io.sarl.lang.util.SynchronizedSet;
import io.sarl.sarlspecification.SarlSpecificationChecker;
import io.sarl.util.Collections3;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import javax.inject.Inject;

@Singleton
public class StandardSpawnService
extends AbstractDependentService
implements SpawnService {
    private static final int CREATION_POOL_SIZE = 128;
    private static final Method MAP_CAPACITY_FUNCTION;
    private static final Method GET_SKILL_FUNCTION;
    private final ListenerCollection<?> globalListeners = new ListenerCollection();
    private final Map<UUID, ListenerCollection<SpawnServiceListener>> agentLifecycleListeners = new TreeMap<UUID, ListenerCollection<SpawnServiceListener>>();
    private final Map<UUID, Agent> agents = new TreeMap<UUID, Agent>();
    private final Injector injector;
    private final SarlSpecificationChecker sarlSpecificationChecker;
    @Inject
    private ExecutorService executor;
    @Inject
    private LogService logger;
    @Inject
    private BuiltinCapacitiesProvider builtinCapacityProvider;

    static {
        try {
            MAP_CAPACITY_FUNCTION = Agent.class.getDeclaredMethod("mapCapacity", Class.class, Skill.class);
            MAP_CAPACITY_FUNCTION.setAccessible(true);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new Error(Messages.StandardSpawnService_4, e);
        }
        try {
            GET_SKILL_FUNCTION = Agent.class.getDeclaredMethod("getSkill", Class.class);
            GET_SKILL_FUNCTION.setAccessible(true);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new Error(Messages.StandardSpawnService_6, e);
        }
    }

    @Inject
    public StandardSpawnService(Injector injector, SarlSpecificationChecker sarlSpecificationChecker) {
        this.injector = injector;
        this.sarlSpecificationChecker = sarlSpecificationChecker;
    }

    protected final Object getAgentRepositoryMutex() {
        return this.agents;
    }

    protected final Object getAgentLifecycleListenerMutex() {
        return this.agentLifecycleListeners;
    }

    @Override
    public final Class<? extends Service> getServiceType() {
        return SpawnService.class;
    }

    @Override
    public Collection<Class<? extends Service>> getServiceDependencies() {
        return Arrays.asList(ContextSpaceService.class);
    }

    private void ensureSarlSpecificationVersion(Class<? extends Agent> agentClazz) {
        if (!this.sarlSpecificationChecker.isValidSarlElement(agentClazz)) {
            throw new InvalidSarlSpecificationException(agentClazz);
        }
    }

    @Override
    public List<UUID> spawn(int nbAgents, UUID spawningAgent, AgentContext parent, UUID agentID, Class<? extends Agent> agentClazz, Object ... params) {
        if (this.isRunning() && nbAgents > 0) {
            try {
                this.ensureSarlSpecificationVersion(agentClazz);
                JustInTimeAgentInjectionModule agentInjectionModule = new JustInTimeAgentInjectionModule(agentClazz, parent.getID(), agentID);
                Injector agentInjector = this.injector.createChildInjector(agentInjectionModule);
                ArrayList<Agent> agents = new ArrayList<Agent>(nbAgents);
                Runnable agentCreator = () -> {
                    Agent agent = agentInjector.getInstance(Agent.class);
                    assert (agent != null);
                    this.builtinCapacityProvider.builtinCapacities(agent, (capacity, skill) -> {
                        try {
                            MAP_CAPACITY_FUNCTION.invoke((Object)agent, capacity, skill);
                        }
                        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                            throw new Error(Messages.StandardSpawnService_5, e);
                        }
                    });
                    Object object = this.agents;
                    synchronized (object) {
                        this.agents.put(agent.getID(), agent);
                    }
                    object = agents;
                    synchronized (object) {
                        agents.add(agent);
                    }
                    this.fireAgentSpawnedInAgent(spawningAgent, parent, agent, params);
                };
                if (nbAgents > 1) {
                    this.executor.executeMultipleTimesInParallelAndWaitForTermination(agentCreator, nbAgents, 128);
                } else {
                    agentCreator.run();
                }
                this.fireAgentSpawnedOutsideAgent(spawningAgent, parent, agentClazz, agents, params);
                return Collections.unmodifiableList(Lists.transform(agents, it -> it.getID()));
            }
            catch (Throwable e) {
                throw new CannotSpawnException(agentClazz, e);
            }
        }
        throw new SpawnDisabledException(parent.getID(), agentClazz);
    }

    protected void fireAgentSpawnedOutsideAgent(UUID spawningAgent, AgentContext context, Class<? extends Agent> agentClazz, List<Agent> agents, Object ... initializationParameters) {
        SpawnServiceListener[] spawnServiceListenerArray = (SpawnServiceListener[])this.globalListeners.getListeners(SpawnServiceListener.class);
        int n = spawnServiceListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            SpawnServiceListener l = spawnServiceListenerArray[n2];
            l.agentSpawned(spawningAgent, context, agents, initializationParameters);
            ++n2;
        }
        EventSpace defSpace = context.getDefaultSpace();
        assert (defSpace != null) : "A context does not contain a default space";
        Address source = new Address(defSpace.getSpaceID(), spawningAgent == null ? context.getID() : spawningAgent);
        assert (source != null);
        AgentSpawned event = new AgentSpawned(source, agentClazz.getName(), Collections2.transform(agents, it -> it.getID()));
        defSpace.emit(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireAgentSpawnedInAgent(UUID spawningAgent, AgentContext context, Agent agent, Object ... initializationParameters) {
        ListenerCollection<SpawnServiceListener> list;
        Map<UUID, ListenerCollection<SpawnServiceListener>> map = this.agentLifecycleListeners;
        synchronized (map) {
            list = this.agentLifecycleListeners.get(agent.getID());
        }
        if (list != null) {
            List<Agent> singleton = Collections.singletonList(agent);
            SpawnServiceListener[] spawnServiceListenerArray = (SpawnServiceListener[])list.getListeners(SpawnServiceListener.class);
            int n = spawnServiceListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                SpawnServiceListener l = spawnServiceListenerArray[n2];
                l.agentSpawned(spawningAgent, context, singleton, initializationParameters);
                ++n2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean killAgent(UUID agentID) {
        String warningMessage;
        boolean error = !this.isRunning();
        boolean isLast = false;
        Agent killAgent = null;
        Object object = this.getAgentRepositoryMutex();
        synchronized (object) {
            boolean foundAgent;
            Agent agent = this.agents.get(agentID);
            boolean bl = foundAgent = agent != null;
            if (foundAgent) {
                if (this.canKillAgent(agent)) {
                    this.agents.remove(agentID);
                    isLast = this.agents.isEmpty();
                    killAgent = agent;
                    warningMessage = null;
                } else {
                    warningMessage = Messages.StandardSpawnService_7;
                }
            } else {
                warningMessage = Messages.StandardSpawnService_8;
            }
        }
        if (warningMessage == null) {
            assert (killAgent != null);
            this.fireAgentDestroyed(killAgent);
            if (isLast) {
                this.fireKernelAgentDestroy();
            }
            if (error) {
                throw new SpawnServiceStopException(agentID);
            }
            return true;
        }
        if (killAgent != null) {
            try {
                Logging skill = (Logging)GET_SKILL_FUNCTION.invoke((Object)killAgent, Logging.class);
                skill.warning((Object)warningMessage, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new Error(Messages.StandardSpawnService_9, e);
            }
        } else {
            this.logger.warning(warningMessage, new Object[0]);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SynchronizedSet<UUID> getAgents() {
        Object mutex;
        Object object = mutex = this.getAgentRepositoryMutex();
        synchronized (object) {
            return Collections3.synchronizedSet(this.agents.keySet(), mutex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Agent getAgent(UUID id) {
        assert (id != null);
        Object object = this.getAgentRepositoryMutex();
        synchronized (object) {
            return this.agents.get(id);
        }
    }

    @Override
    public void addKernelAgentSpawnListener(KernelAgentSpawnListener listener) {
        this.globalListeners.add(KernelAgentSpawnListener.class, listener);
    }

    @Override
    public void removeKernelAgentSpawnListener(KernelAgentSpawnListener listener) {
        this.globalListeners.remove(KernelAgentSpawnListener.class, listener);
    }

    protected void fireKernelAgentSpawn() {
        KernelAgentSpawnListener[] kernelAgentSpawnListenerArray = (KernelAgentSpawnListener[])this.globalListeners.getListeners(KernelAgentSpawnListener.class);
        int n = kernelAgentSpawnListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            KernelAgentSpawnListener l = kernelAgentSpawnListenerArray[n2];
            l.kernelAgentSpawn();
            ++n2;
        }
    }

    protected void fireKernelAgentDestroy() {
        KernelAgentSpawnListener[] kernelAgentSpawnListenerArray = (KernelAgentSpawnListener[])this.globalListeners.getListeners(KernelAgentSpawnListener.class);
        int n = kernelAgentSpawnListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            KernelAgentSpawnListener l = kernelAgentSpawnListenerArray[n2];
            l.kernelAgentDestroy();
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSpawnServiceListener(UUID id, SpawnServiceListener agentLifecycleListener) {
        Object object = this.getAgentLifecycleListenerMutex();
        synchronized (object) {
            ListenerCollection<SpawnServiceListener> listeners = this.agentLifecycleListeners.get(id);
            if (listeners == null) {
                listeners = new ListenerCollection();
                this.agentLifecycleListeners.put(id, listeners);
            }
            listeners.add(SpawnServiceListener.class, agentLifecycleListener);
        }
    }

    @Override
    public void addSpawnServiceListener(SpawnServiceListener agentLifecycleListener) {
        this.globalListeners.add(SpawnServiceListener.class, agentLifecycleListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSpawnServiceListener(UUID id, SpawnServiceListener agentLifecycleListener) {
        Object object = this.getAgentLifecycleListenerMutex();
        synchronized (object) {
            ListenerCollection<SpawnServiceListener> listeners = this.agentLifecycleListeners.get(id);
            if (listeners != null) {
                listeners.remove(SpawnServiceListener.class, agentLifecycleListener);
                if (listeners.isEmpty()) {
                    this.agentLifecycleListeners.remove(id);
                }
            }
        }
    }

    @Override
    public void removeSpawnServiceListener(SpawnServiceListener agentLifecycleListener) {
        this.globalListeners.remove(SpawnServiceListener.class, agentLifecycleListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean canKillAgent(Agent agent) {
        try {
            AgentContext ac = BuiltinCapacityUtil.getContextIn(agent);
            if (ac == null) return true;
            SynchronizedSet<UUID> participants = ac.getDefaultSpace().getParticipants();
            if (participants == null) return true;
            Object object = participants.mutex();
            synchronized (object) {
                if (participants.size() > 1) return false;
                if (participants.size() != 1) return true;
                if (participants.contains(agent.getID())) return true;
                return false;
            }
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireAgentDestroyed(Agent agent) {
        SpawnServiceListener l;
        SpawnServiceListener[] spawnServiceListenerArray;
        ListenerCollection<SpawnServiceListener> list;
        Object object = this.getAgentLifecycleListenerMutex();
        synchronized (object) {
            list = this.agentLifecycleListeners.get(agent.getID());
        }
        SpawnServiceListener[] ilisteners = list != null ? (SpawnServiceListener[])list.getListeners(SpawnServiceListener.class) : null;
        SpawnServiceListener[] ilisteners2 = (SpawnServiceListener[])this.globalListeners.getListeners(SpawnServiceListener.class);
        try {
            SynchronizedCollection<AgentContext> sc = BuiltinCapacityUtil.getContextsOf(agent);
            Object object2 = sc.mutex();
            synchronized (object2) {
                for (AgentContext context : sc) {
                    EventSpace defSpace = context.getDefaultSpace();
                    defSpace.emit(new AgentKilled(defSpace.getAddress(agent.getID()), agent.getID(), agent.getClass().getName()));
                }
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (ilisteners != null) {
            spawnServiceListenerArray = ilisteners;
            int n = ilisteners.length;
            int n2 = 0;
            while (n2 < n) {
                l = spawnServiceListenerArray[n2];
                l.agentDestroy(agent);
                ++n2;
            }
        }
        spawnServiceListenerArray = ilisteners2;
        int n = ilisteners2.length;
        int n3 = 0;
        while (n3 < n) {
            l = spawnServiceListenerArray[n3];
            l.agentDestroy(agent);
            ++n3;
        }
    }

    @Override
    protected void doStart() {
        this.fireKernelAgentSpawn();
        this.notifyStarted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doStop() {
        Object object = this.getAgentLifecycleListenerMutex();
        synchronized (object) {
            this.agentLifecycleListeners.clear();
        }
        this.notifyStopped();
    }

    public static class CannotSpawnException
    extends RuntimeException {
        private static final long serialVersionUID = -380402400888610762L;

        public CannotSpawnException(Class<? extends Agent> agentClazz, Throwable cause) {
            super(MessageFormat.format(Messages.StandardSpawnService_3, agentClazz, cause == null ? null : cause.getLocalizedMessage()), cause);
        }
    }

    public static class InvalidSarlSpecificationException
    extends RuntimeException {
        private static final long serialVersionUID = -3194494637438344108L;

        public InvalidSarlSpecificationException(Class<? extends Agent> agentType) {
            super(MessageFormat.format(Messages.StandardSpawnService_2, agentType.getName()));
        }
    }

    private static class JustInTimeAgentInjectionModule
    extends AbstractModule
    implements Provider<Agent> {
        private final Class<? extends Agent> agentType;
        private final Constructor<? extends Agent> constructor1;
        private final Constructor<? extends Agent> constructor2;
        private final UUID parentID;
        private final UUID agentID;

        JustInTimeAgentInjectionModule(Class<? extends Agent> agentType, UUID parentID, UUID agentID) {
            Constructor<? extends Agent> cons;
            assert (agentType != null);
            assert (parentID != null);
            this.agentType = agentType;
            this.parentID = parentID;
            this.agentID = agentID == null ? UUID.randomUUID() : agentID;
            Exception e1 = null;
            try {
                cons = this.agentType.getConstructor(UUID.class, UUID.class);
            }
            catch (IllegalArgumentException | NoSuchMethodException | SecurityException exception) {
                cons = null;
                e1 = exception;
            }
            this.constructor1 = cons;
            Exception e2 = null;
            try {
                cons = this.agentType.getConstructor(BuiltinCapacitiesProvider.class, UUID.class, UUID.class);
            }
            catch (IllegalArgumentException | NoSuchMethodException | SecurityException exception) {
                cons = null;
                e2 = exception;
            }
            this.constructor2 = cons;
            if (this.constructor1 == null && this.constructor2 == null) {
                throw new CannotSpawnException(this.agentType, (Throwable)(e1 == null ? e2 : e1));
            }
        }

        @Override
        public void configure() {
            this.bind(Agent.class).toProvider(this);
        }

        @Override
        public Agent get() {
            assert (this.constructor1 != null || this.constructor2 != null);
            try {
                if (this.constructor1 != null) {
                    return this.constructor1.newInstance(this.parentID, this.agentID);
                }
                return this.constructor2.newInstance(null, this.parentID, this.agentID);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException exception) {
                throw new CannotSpawnException(this.agentType, (Throwable)exception);
            }
        }
    }

    public static class SpawnDisabledException
    extends RuntimeException {
        private static final long serialVersionUID = -380402400888610762L;

        public SpawnDisabledException(UUID parentID, Class<? extends Agent> agentClazz) {
            super(MessageFormat.format(Messages.StandardSpawnService_0, parentID, agentClazz));
        }
    }

    public static class SpawnServiceStopException
    extends RuntimeException {
        private static final long serialVersionUID = 8104012713598435249L;

        public SpawnServiceStopException(UUID agentID) {
            super(MessageFormat.format(Messages.StandardSpawnService_1, agentID));
        }
    }
}

