/*
 * Decompiled with CFR 0.152.
 */
package io.janusproject.kernel.services.jdk.network;

import com.google.inject.Inject;
import io.janusproject.kernel.services.jdk.network.Messages;
import io.janusproject.services.network.AbstractEventEncrypter;
import io.janusproject.services.network.EventEnvelope;
import io.janusproject.services.network.NetworkConfig;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.util.UUID;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.inject.Named;

public class AESEventEncrypter
extends AbstractEventEncrypter {
    private static final String ALGORITHM = "AES/CBC/PKCS5Padding";
    private SecretKeySpec skeySpec;

    @Inject
    public void setKey(@Named(value="network.encrypter.aes.key") String key) throws Exception {
        byte[] raw = key.getBytes(NetworkConfig.getStringEncodingCharset());
        int keySize = raw.length;
        if (keySize % 16 != 0 && keySize % 24 != 0 && keySize % 32 != 0) {
            throw new IllegalArgumentException(Messages.AESEventEncrypter_0);
        }
        this.skeySpec = new SecretKeySpec(raw, "AES");
    }

    @Override
    public void encrypt(EventEnvelope envelope) throws Exception {
        assert (envelope != null) : "Parameter 'envelope' must not be null";
        Cipher cipher = Cipher.getInstance(ALGORITHM);
        cipher.init(1, (Key)this.skeySpec, new IvParameterSpec(new byte[16]));
        envelope.setContextId(cipher.doFinal(envelope.getContextId()));
        envelope.setSpaceId(cipher.doFinal(envelope.getSpaceId()));
        envelope.setScope(cipher.doFinal(envelope.getScope()));
        envelope.setCustomHeaders(cipher.doFinal(envelope.getCustomHeaders()));
        envelope.setBody(cipher.doFinal(envelope.getBody()));
    }

    @Override
    public void decrypt(EventEnvelope envelope) throws Exception {
        assert (envelope != null) : "Parameter 'envelope' must not be null";
        Cipher cipher = Cipher.getInstance(ALGORITHM);
        cipher.init(2, (Key)this.skeySpec, new IvParameterSpec(new byte[16]));
        envelope.setContextId(cipher.doFinal(envelope.getContextId()));
        envelope.setSpaceId(cipher.doFinal(envelope.getSpaceId()));
        envelope.setScope(cipher.doFinal(envelope.getScope()));
        envelope.setCustomHeaders(cipher.doFinal(envelope.getCustomHeaders()));
        envelope.setBody(cipher.doFinal(envelope.getBody()));
    }

    @Override
    public byte[] encryptUUID(UUID uuid) {
        try {
            Cipher cipher = Cipher.getInstance(ALGORITHM);
            cipher.init(1, (Key)this.skeySpec, new IvParameterSpec(new byte[16]));
            return cipher.doFinal(super.encryptUUID(uuid));
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }
}

