/*
 * Decompiled with CFR 0.152.
 */
package io.janusproject.kernel.services.jdk.logging;

import com.google.common.base.Strings;
import com.google.common.util.concurrent.Service;
import com.google.inject.Inject;
import io.janusproject.services.AbstractDependentService;
import io.janusproject.services.logging.LogService;
import io.janusproject.util.ClassFinder;
import java.text.MessageFormat;
import java.util.logging.Filter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class StandardLogService
extends AbstractDependentService
implements LogService {
    private Logger logger;
    private LoggerCallerProvider loggerCallerProvider = new StackTraceLoggerCallerProvider();

    public LoggerCallerProvider getLoggerCaller() {
        return this.loggerCallerProvider;
    }

    public void setLoggerCaller(LoggerCallerProvider provider) {
        this.loggerCallerProvider = provider == null ? new StackTraceLoggerCallerProvider() : provider;
    }

    @Override
    public final Class<? extends Service> getServiceType() {
        return LogService.class;
    }

    protected boolean isLogEnabled() {
        return this.state().ordinal() <= Service.State.RUNNING.ordinal();
    }

    private static LogRecord createLogRecord(Level level, String text, boolean exception, Object ... message) {
        Throwable realException = null;
        if (exception) {
            Object[] objectArray = message;
            int n = message.length;
            int n2 = 0;
            while (n2 < n) {
                Object m = objectArray[n2];
                if (m instanceof Throwable) {
                    realException = (Throwable)m;
                    break;
                }
                ++n2;
            }
        }
        LogRecord record = new LogRecord(level, text);
        if (realException != null) {
            record.setThrown(realException);
        }
        if (record.getLoggerName() == null) {
            record.setLoggerName("Janus SRE");
        }
        return record;
    }

    private void writeInLog(Level level, boolean exception, String message, Object ... params) {
        if (this.isLogEnabled() && this.logger.isLoggable(level)) {
            LoggerCaller caller = this.loggerCallerProvider.getLoggerCaller();
            String text = MessageFormat.format(message, params);
            LogRecord record = StandardLogService.createLogRecord(level, text, exception, params);
            record.setSourceClassName(caller.getTypeName());
            String methodName = caller.getMethod();
            if (!Strings.isNullOrEmpty(methodName)) {
                record.setSourceMethodName(methodName);
            }
            this.logger.log(record);
        }
    }

    @Override
    public void log(LogRecord record) {
        if (this.isLogEnabled()) {
            this.logger.log(record);
        }
    }

    @Override
    public void log(Level level, String message, Object ... params) {
        this.writeInLog(level, true, message, params);
    }

    @Override
    public void info(String message, Object ... params) {
        this.writeInLog(Level.INFO, false, message, params);
    }

    @Override
    public void fineInfo(String message, Object ... params) {
        this.writeInLog(Level.FINE, false, message, params);
    }

    @Override
    public void finerInfo(String message, Object ... params) {
        this.writeInLog(Level.FINER, false, message, params);
    }

    @Override
    public void debug(String message, Object ... params) {
        this.writeInLog(Level.FINEST, true, message, params);
    }

    @Override
    public void warning(String message, Object ... params) {
        this.writeInLog(Level.WARNING, true, message, params);
    }

    @Override
    public void warning(Throwable exception) {
        this.writeInLog(Level.WARNING, true, exception.getLocalizedMessage(), exception);
    }

    @Override
    public void error(String message, Object ... params) {
        this.writeInLog(Level.SEVERE, true, message, params);
    }

    @Override
    public void error(Throwable exception) {
        this.writeInLog(Level.SEVERE, true, exception.getLocalizedMessage(), exception);
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    @Override
    @Inject
    public void setLogger(Logger logger) {
        if (logger != null) {
            this.logger = logger;
        }
    }

    @Override
    public void setFilter(Filter filter) {
        this.logger.setFilter(filter);
    }

    @Override
    public Filter getFilter() {
        return this.logger.getFilter();
    }

    @Override
    public boolean isLoggeable(Level level) {
        return this.isLogEnabled() && this.logger.isLoggable(level);
    }

    @Override
    public Level getLevel() {
        return this.logger.getLevel();
    }

    @Override
    public void setLevel(Level level) {
        this.logger.setLevel(level);
    }

    @Override
    protected void doStart() {
        this.notifyStarted();
    }

    @Override
    protected void doStop() {
        this.notifyStopped();
    }

    public static class LoggerCaller {
        private final String methodName;
        private final String className;

        public LoggerCaller(String className, String methodName) {
            this.className = className;
            this.methodName = methodName;
        }

        public String getTypeName() {
            return this.className;
        }

        public String getMethod() {
            return this.methodName;
        }
    }

    public static interface LoggerCallerProvider {
        public LoggerCaller getLoggerCaller();
    }

    public static class StackTraceLoggerCallerProvider
    implements LoggerCallerProvider {
        private static StackTraceElement getStackTraceElement() {
            StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
            int i = 1;
            while (i < stackTrace.length) {
                String className = stackTrace[i].getClassName();
                Class<?> type = ClassFinder.findClass(className);
                if (type != null) {
                    return stackTrace[i];
                }
                ++i;
            }
            return null;
        }

        @Override
        public LoggerCaller getLoggerCaller() {
            StackTraceElement element = StackTraceLoggerCallerProvider.getStackTraceElement();
            if (element != null) {
                return new LoggerCaller(element.getClassName(), element.getMethodName());
            }
            return null;
        }
    }
}

