/*
 * Decompiled with CFR 0.152.
 */
package io.janusproject.kernel.services.jdk.kerneldiscovery;

import com.google.common.util.concurrent.Service;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.janusproject.services.AbstractDependentService;
import io.janusproject.services.AsyncStateService;
import io.janusproject.services.executor.ExecutorService;
import io.janusproject.services.kerneldiscovery.KernelDiscoveryService;
import io.janusproject.services.kerneldiscovery.KernelDiscoveryServiceListener;
import io.janusproject.services.network.NetworkService;
import io.janusproject.util.TwoStepConstruction;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;

@Singleton
@TwoStepConstruction
public class StandardKernelDiscoveryService
extends AbstractDependentService
implements KernelDiscoveryService,
AsyncStateService {
    private URI localURI;
    private boolean isReady;
    private NetworkService network;

    protected final Object getServiceMutex() {
        return this;
    }

    @Inject
    void postConstruction(NetworkService networkService, ExecutorService executorService) {
        this.network = networkService;
        this.network.addListener(new NetworkStartListener(), executorService.getExecutorService());
    }

    @Override
    public Collection<Class<? extends Service>> getServiceDependencies() {
        return Arrays.asList(ExecutorService.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isReadyForOtherServices() {
        if (this.isRunning()) {
            Object object = this.getServiceMutex();
            synchronized (object) {
                return this.isReady;
            }
        }
        return false;
    }

    @Override
    public final Class<? extends Service> getServiceType() {
        return KernelDiscoveryService.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public URI getCurrentKernel() {
        Object object = this.getServiceMutex();
        synchronized (object) {
            return this.localURI;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<URI> getKernels() {
        Object object = this.getServiceMutex();
        synchronized (object) {
            return Collections.singleton(this.localURI);
        }
    }

    @Override
    public void addKernelDiscoveryServiceListener(KernelDiscoveryServiceListener listener) {
    }

    @Override
    public void removeKernelDiscoveryServiceListener(KernelDiscoveryServiceListener listener) {
    }

    @Override
    protected void doStart() {
        this.notifyStarted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doStop() {
        Object object = this.getServiceMutex();
        synchronized (object) {
            this.isReady = false;
        }
        this.notifyStopped();
    }

    private class NetworkStartListener
    extends Service.Listener {
        NetworkStartListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void running() {
            URI uri = StandardKernelDiscoveryService.this.network.getURI();
            if (StandardKernelDiscoveryService.this.localURI == null) {
                Collection<Class<? extends Service>> collection = StandardKernelDiscoveryService.this.getServiceDependencies();
                synchronized (collection) {
                    StandardKernelDiscoveryService.this.localURI = uri;
                    StandardKernelDiscoveryService.this.isReady = true;
                }
            }
        }
    }
}

