/*
 * Decompiled with CFR 0.152.
 */
package io.janusproject.kernel.services.jdk.executors;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.janusproject.kernel.services.jdk.executors.Messages;
import io.janusproject.services.executor.EarlyExitException;
import io.janusproject.services.logging.LogService;
import java.text.MessageFormat;
import java.util.concurrent.CancellationException;
import java.util.logging.Level;
import java.util.logging.LogRecord;

@Singleton
public class JdkUncaughtExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private final LogService logger;

    @Inject
    public JdkUncaughtExceptionHandler(LogService logger) {
        assert (logger != null);
        this.logger = logger;
    }

    private void log(Throwable exception, String taskId, String taskName) {
        LogRecord record;
        assert (exception != null);
        Throwable cause = exception;
        while (cause.getCause() != null && cause.getCause() != cause) {
            cause = cause.getCause();
        }
        if (cause instanceof EarlyExitException || exception instanceof EarlyExitException) {
            return;
        }
        if (cause instanceof CancellationException || exception instanceof CancellationException) {
            if (!this.logger.isLoggeable(Level.FINEST)) {
                return;
            }
            record = new LogRecord(Level.FINEST, MessageFormat.format(Messages.JdkUncaughtExceptionHandler_0, taskId, taskName));
        } else if (cause instanceof InterruptedException || exception instanceof InterruptedException) {
            if (!this.logger.isLoggeable(Level.FINEST)) {
                return;
            }
            record = new LogRecord(Level.FINEST, MessageFormat.format(Messages.JdkUncaughtExceptionHandler_1, taskId, taskName));
        } else {
            if (!this.logger.isLoggeable(Level.SEVERE)) {
                return;
            }
            record = new LogRecord(Level.SEVERE, MessageFormat.format(Messages.JdkUncaughtExceptionHandler_2, cause.getLocalizedMessage(), taskId, taskName));
        }
        record.setThrown(cause);
        StackTraceElement[] trace = cause.getStackTrace();
        if (trace != null && trace.length > 0) {
            StackTraceElement elt = trace[0];
            assert (elt != null);
            record.setSourceClassName(elt.getClassName());
            record.setSourceMethodName(elt.getMethodName());
        }
        this.logger.log(record);
    }

    @Override
    public void uncaughtException(Thread thread, Throwable exception) {
        this.log(exception, Long.toString(thread.getId()), thread.getName());
    }
}

