/*
 * Decompiled with CFR 0.152.
 */
package io.janusproject.kernel.services.jdk.contextspace;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.util.concurrent.Service;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import io.janusproject.kernel.services.jdk.contextspace.Context;
import io.janusproject.kernel.services.jdk.contextspace.ContextFactory;
import io.janusproject.kernel.services.jdk.contextspace.Messages;
import io.janusproject.kernel.services.jdk.contextspace.SpaceRepositoryFactory;
import io.janusproject.services.AbstractDependentService;
import io.janusproject.services.contextspace.ContextRepositoryListener;
import io.janusproject.services.contextspace.ContextSpaceService;
import io.janusproject.services.contextspace.SpaceRepositoryListener;
import io.janusproject.services.distributeddata.DMap;
import io.janusproject.services.distributeddata.DMapListener;
import io.janusproject.services.distributeddata.DistributedDataStructureService;
import io.janusproject.services.kerneldiscovery.KernelDiscoveryService;
import io.janusproject.services.logging.LogService;
import io.janusproject.services.network.NetworkService;
import io.janusproject.util.ListenerCollection;
import io.janusproject.util.TwoStepConstruction;
import io.sarl.lang.core.AgentContext;
import io.sarl.lang.core.EventSpace;
import io.sarl.lang.core.Space;
import io.sarl.lang.core.SpaceID;
import io.sarl.util.Collections3;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;

@Singleton
@TwoStepConstruction
public class StandardContextSpaceService
extends AbstractDependentService
implements ContextSpaceService {
    private final ListenerCollection<?> listeners = new ListenerCollection();
    private ContextFactory contextFactory;
    private SpaceRepositoryFactory spaceRepositoryFactory;
    private DMap<UUID, SpaceID> defaultSpaces;
    private Map<UUID, AgentContext> contexts = new TreeMap<UUID, AgentContext>();
    private ContextDMapListener dmapListener;
    private LogService logger;

    @Override
    public final Class<? extends Service> getServiceType() {
        return ContextSpaceService.class;
    }

    @Override
    public Collection<Class<? extends Service>> getServiceDependencies() {
        return Arrays.asList(DistributedDataStructureService.class, NetworkService.class, KernelDiscoveryService.class);
    }

    ContextFactory getContextFactory() {
        return this.contextFactory;
    }

    void setContextFactory(ContextFactory factory) {
        if (factory != null) {
            this.contextFactory = factory;
        }
    }

    SpaceRepositoryFactory getSpaceRepositoryFactory() {
        return this.spaceRepositoryFactory;
    }

    void setSpaceRepositoryFactory(SpaceRepositoryFactory factory) {
        if (factory != null) {
            this.spaceRepositoryFactory = factory;
        }
    }

    @Override
    public final Object mutex() {
        return this;
    }

    @Inject
    void postConstruction(@Named(value="janus.context.id") UUID janusID, DistributedDataStructureService dataStructureService, LogService logService, Injector injector) {
        this.logger = logService;
        this.contextFactory = new DefaultContextFactory();
        this.spaceRepositoryFactory = new Context.DefaultSpaceRepositoryFactory(injector, dataStructureService, logService);
        this.defaultSpaces = dataStructureService.getMap(janusID.toString(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmptyContextRepository() {
        Object object = this.mutex();
        synchronized (object) {
            return this.contexts.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNumberOfContexts() {
        Object object = this.mutex();
        synchronized (object) {
            return this.contexts.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsContext(UUID contextID) {
        Object object = this.mutex();
        synchronized (object) {
            return this.contexts.containsKey(contextID);
        }
    }

    @Override
    public synchronized AgentContext createContext(UUID contextID, UUID defaultSpaceUUID) {
        assert (contextID != null) : "The contextID cannot be null";
        assert (defaultSpaceUUID != null) : "The defaultSpaceUUID cannot be null";
        assert (this.contexts != null) : "Internal Error: the context container must not be null";
        AgentContext context = this.contexts.get(contextID);
        if (context == null) {
            Context ctx = this.contextFactory.newInstance(contextID, defaultSpaceUUID, this.spaceRepositoryFactory, new SpaceEventProxy());
            assert (ctx != null) : "The internal Context cannot be null";
            assert (this.contexts != null) : "Internal Error: the context container must not be null";
            this.contexts.put(contextID, ctx);
            this.fireContextCreated(ctx);
            EventSpace defaultSpace = ctx.postConstruction();
            assert (defaultSpace != null) : "The default space in the context " + contextID + " cannot be null";
            this.defaultSpaces.putIfAbsent(ctx.getID(), defaultSpace.getSpaceID());
            return ctx;
        }
        return context;
    }

    @Override
    public final void removeContext(AgentContext context) {
        this.removeContext(context.getID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeContext(UUID contextID) {
        AgentContext context = null;
        Object object = this.mutex();
        synchronized (object) {
            this.defaultSpaces.remove(contextID);
            context = this.contexts.remove(contextID);
            if (context != null) {
                ((Context)context).destroy();
            }
        }
        if (context != null) {
            this.fireContextDestroyed(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<AgentContext> getContexts() {
        Object object = this.mutex();
        synchronized (object) {
            return Collections.unmodifiableCollection(Collections3.synchronizedCollection(this.contexts.values(), this.mutex()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<AgentContext> getContexts(final Collection<UUID> contextIDs) {
        Object object = this.mutex();
        synchronized (object) {
            return Collections2.filter(this.contexts.values(), new Predicate<AgentContext>(){

                @Override
                public boolean apply(AgentContext input) {
                    return contextIDs.contains(input.getID());
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<UUID> getContextIDs() {
        Object object = this.mutex();
        synchronized (object) {
            return Collections.unmodifiableSet(Collections3.synchronizedSet(this.contexts.keySet(), this.mutex()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AgentContext getContext(UUID contextID) {
        Object object = this.mutex();
        synchronized (object) {
            return this.contexts.get(contextID);
        }
    }

    @Override
    public void addContextRepositoryListener(ContextRepositoryListener listener) {
        this.listeners.add(ContextRepositoryListener.class, listener);
    }

    @Override
    public void removeContextRepositoryListener(ContextRepositoryListener listener) {
        this.listeners.remove(ContextRepositoryListener.class, listener);
    }

    protected void fireContextCreated(AgentContext context) {
        ContextRepositoryListener[] ilisteners = (ContextRepositoryListener[])this.listeners.getListeners(ContextRepositoryListener.class);
        this.logger.info(Messages.StandardContextSpaceService_0, context.getID());
        ContextRepositoryListener[] contextRepositoryListenerArray = ilisteners;
        int n = ilisteners.length;
        int n2 = 0;
        while (n2 < n) {
            ContextRepositoryListener listener = contextRepositoryListenerArray[n2];
            listener.contextCreated(context);
            ++n2;
        }
    }

    protected void fireContextDestroyed(AgentContext context) {
        ContextRepositoryListener[] ilisteners = (ContextRepositoryListener[])this.listeners.getListeners(ContextRepositoryListener.class);
        this.logger.info(Messages.StandardContextSpaceService_1, context.getID());
        ContextRepositoryListener[] contextRepositoryListenerArray = ilisteners;
        int n = ilisteners.length;
        int n2 = 0;
        while (n2 < n) {
            ContextRepositoryListener listener = contextRepositoryListenerArray[n2];
            listener.contextDestroyed(context);
            ++n2;
        }
    }

    @Override
    public void addSpaceRepositoryListener(SpaceRepositoryListener listener) {
        this.listeners.add(SpaceRepositoryListener.class, listener);
    }

    @Override
    public void removeSpaceRepositoryListener(SpaceRepositoryListener listener) {
        this.listeners.remove(SpaceRepositoryListener.class, listener);
    }

    protected void fireSpaceCreated(Space space, boolean isLocalCreation) {
        SpaceRepositoryListener[] spaceRepositoryListenerArray = (SpaceRepositoryListener[])this.listeners.getListeners(SpaceRepositoryListener.class);
        int n = spaceRepositoryListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            SpaceRepositoryListener listener = spaceRepositoryListenerArray[n2];
            listener.spaceCreated(space, isLocalCreation);
            ++n2;
        }
    }

    protected void fireSpaceDestroyed(Space space, boolean isLocalDestruction) {
        SpaceRepositoryListener[] spaceRepositoryListenerArray = (SpaceRepositoryListener[])this.listeners.getListeners(SpaceRepositoryListener.class);
        int n = spaceRepositoryListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            SpaceRepositoryListener listener = spaceRepositoryListenerArray[n2];
            listener.spaceDestroyed(space, isLocalDestruction);
            ++n2;
        }
    }

    protected void ensureDefaultSpaceDefinition(SpaceID spaceID) {
        this.createContext(spaceID.getContextID(), spaceID.getID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeDefaultSpaceDefinition(SpaceID spaceID) {
        AgentContext context = null;
        Object object = this.mutex();
        synchronized (object) {
            context = this.contexts.remove(spaceID.getContextID());
        }
        if (context != null) {
            this.fireContextDestroyed(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doStart() {
        Object object = this.mutex();
        synchronized (object) {
            for (SpaceID space : this.defaultSpaces.values()) {
                this.ensureDefaultSpaceDefinition(space);
            }
            this.dmapListener = new ContextDMapListener();
            this.defaultSpaces.addDMapListener(this.dmapListener);
        }
        this.notifyStarted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doStop() {
        Map<UUID, AgentContext> old;
        Object object = this.mutex();
        synchronized (object) {
            if (this.dmapListener != null) {
                this.defaultSpaces.removeDMapListener(this.dmapListener);
            }
            old = this.contexts;
            this.contexts = new TreeMap<UUID, AgentContext>();
        }
        for (AgentContext context : old.values()) {
            ((Context)context).destroy();
            this.fireContextDestroyed(context);
        }
        this.notifyStopped();
    }

    private class ContextDMapListener
    implements DMapListener<UUID, SpaceID> {
        ContextDMapListener() {
        }

        @Override
        public void entryAdded(UUID key, SpaceID value) {
            assert (value != null);
            StandardContextSpaceService.this.ensureDefaultSpaceDefinition(value);
        }

        @Override
        public void entryRemoved(UUID key, SpaceID value) {
            assert (value != null);
            StandardContextSpaceService.this.removeDefaultSpaceDefinition(value);
        }

        @Override
        public void entryUpdated(UUID key, SpaceID value) {
        }

        @Override
        public void mapCleared(boolean localClearing) {
            throw new UnsupportedOperationException();
        }
    }

    private static class DefaultContextFactory
    implements ContextFactory {
        DefaultContextFactory() {
        }

        @Override
        public Context newInstance(UUID contextId, UUID defaultSpaceId, SpaceRepositoryFactory factory, SpaceRepositoryListener listener) {
            return new Context(contextId, defaultSpaceId, factory, listener);
        }
    }

    private class SpaceEventProxy
    implements SpaceRepositoryListener {
        SpaceEventProxy() {
        }

        @Override
        public void spaceCreated(Space space, boolean isLocalCreation) {
            StandardContextSpaceService.this.fireSpaceCreated(space, isLocalCreation);
        }

        @Override
        public void spaceDestroyed(Space space, boolean isLocalDestruction) {
            StandardContextSpaceService.this.fireSpaceDestroyed(space, isLocalDestruction);
        }
    }
}

