/*
 * Decompiled with CFR 0.152.
 */
package io.janusproject.kernel.services.gson;

import com.google.gson.Gson;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.reflect.TypeToken;
import com.google.inject.Inject;
import io.janusproject.kernel.services.gson.Messages;
import io.janusproject.services.network.AbstractEventSerializer;
import io.janusproject.services.network.EventDispatch;
import io.janusproject.services.network.EventEncrypter;
import io.janusproject.services.network.EventEnvelope;
import io.janusproject.services.network.NetworkConfig;
import io.janusproject.services.network.NetworkUtil;
import io.janusproject.util.ClassFinder;
import io.sarl.lang.core.Event;
import io.sarl.lang.core.Scope;
import io.sarl.lang.core.SpaceID;
import io.sarl.lang.core.SpaceSpecification;
import java.lang.reflect.Type;
import java.text.MessageFormat;
import java.util.Map;
import java.util.UUID;

public class GsonEventSerializer
extends AbstractEventSerializer {
    protected final Gson gson;

    @Inject
    public GsonEventSerializer(Gson gson, EventEncrypter encrypter) {
        super(encrypter);
        this.gson = gson;
    }

    @Override
    public EventEnvelope serialize(EventDispatch dispatch) throws Exception {
        assert (this.encrypter != null) : "Invalid injection of the encrypter";
        assert (this.gson != null) : "Invalid injection of Gson";
        assert (dispatch != null) : "Parameter 'dispatch' must not be null";
        Event event = dispatch.getEvent();
        assert (event != null);
        Scope<?> scope = dispatch.getScope();
        assert (scope != null);
        SpaceID spaceID = dispatch.getSpaceID();
        assert (spaceID != null);
        assert (spaceID.getSpaceSpecification() != null);
        Map<String, String> headers = dispatch.getCustomHeaders();
        assert (headers != null);
        headers.put("x-java-event-class", event.getClass().getName());
        headers.put("x-java-scope-class", scope.getClass().getName());
        headers.put("x-java-spacespec-class", spaceID.getSpaceSpecification().getName());
        EventEnvelope envelope = new EventEnvelope(NetworkUtil.toByteArray(spaceID.getContextID()), NetworkUtil.toByteArray(spaceID.getID()), this.gson.toJson(scope).getBytes(NetworkConfig.getStringEncodingCharset()), this.gson.toJson(dispatch.getCustomHeaders()).getBytes(NetworkConfig.getStringEncodingCharset()), this.gson.toJson(event).getBytes(NetworkConfig.getStringEncodingCharset()));
        this.encrypter.encrypt(envelope);
        return envelope;
    }

    private static Map<String, String> getHeadersFromString(String src) {
        Gson gson = new Gson();
        Type headersType = new TypeToken<Map<String, String>>(){}.getType();
        return (Map)gson.fromJson(src, headersType);
    }

    @Override
    public EventDispatch deserialize(EventEnvelope envelope) throws Exception {
        assert (this.encrypter != null) : "Invalid injection of the encrypter";
        assert (this.gson != null) : "Invalid injection of Gson";
        this.encrypter.decrypt(envelope);
        UUID contextId = NetworkUtil.fromByteArray(envelope.getContextId());
        UUID spaceId = NetworkUtil.fromByteArray(envelope.getSpaceId());
        Map<String, String> headers = GsonEventSerializer.getHeadersFromString(new String(envelope.getCustomHeaders(), NetworkConfig.getStringEncodingCharset()));
        Class<SpaceSpecification> spaceSpec = GsonEventSerializer.extractClass("x-java-spacespec-class", headers, SpaceSpecification.class);
        Class<Event> eventClazz = GsonEventSerializer.extractClass("x-java-event-class", headers, Event.class);
        Class<Scope> scopeClazz = GsonEventSerializer.extractClass("x-java-scope-class", headers, Scope.class);
        SpaceID spaceID = new SpaceID(contextId, spaceId, spaceSpec);
        Event event = this.gson.fromJson(new String(envelope.getBody(), NetworkConfig.getStringEncodingCharset()), eventClazz);
        assert (event != null);
        Scope scope = this.gson.fromJson(new String(envelope.getScope(), NetworkConfig.getStringEncodingCharset()), scopeClazz);
        assert (scope != null);
        return new EventDispatch(spaceID, event, scope, headers);
    }

    private static <T> Class<? extends T> extractClass(String key, Map<String, String> headers, Class<T> expectedType) {
        assert (key != null);
        assert (headers != null);
        String classname = headers.get(key);
        Class<?> type = null;
        if (classname != null) {
            type = ClassFinder.findClass(classname);
        }
        if (type == null || !expectedType.isAssignableFrom(type)) {
            throw new ClassCastException(MessageFormat.format(Messages.GsonEventSerializer_0, type));
        }
        assert (type != null);
        return type.asSubclass(expectedType);
    }

    public static class ClassTypeAdapter
    implements JsonSerializer<Class<?>>,
    JsonDeserializer<Class<?>> {
        @Override
        public JsonElement serialize(Class<?> src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(src.getName());
        }

        @Override
        public Class<?> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            try {
                return Class.forName(json.getAsString());
            }
            catch (ClassNotFoundException e) {
                throw new JsonParseException(e);
            }
        }
    }
}

