/*
 * Decompiled with CFR 0.152.
 */
package io.janusproject.kernel.repository;

import io.janusproject.kernel.repository.ParticipantRepository;
import io.janusproject.services.distributeddata.DistributedDataStructureService;
import io.sarl.lang.core.EventListener;
import io.sarl.lang.util.SynchronizedCollection;
import io.sarl.lang.util.SynchronizedSet;
import io.sarl.util.Collections3;
import java.io.Serializable;
import java.util.Map;
import java.util.UUID;

public final class UniqueAddressParticipantRepository<ADDRESST extends Serializable>
extends ParticipantRepository<ADDRESST> {
    private final Map<UUID, ADDRESST> participants;
    private final String distributedParticipantMapName;

    public UniqueAddressParticipantRepository(String distributedParticipantMapName, DistributedDataStructureService repositoryImplFactory) {
        this.distributedParticipantMapName = distributedParticipantMapName;
        this.participants = repositoryImplFactory.getMap(this.distributedParticipantMapName, null);
    }

    @Override
    public Object mutex() {
        return this.participants;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ADDRESST registerParticipant(ADDRESST address, EventListener entity) {
        Object object = this.mutex();
        synchronized (object) {
            this.addListener(address, entity);
            this.participants.put(entity.getID(), address);
        }
        return address;
    }

    public ADDRESST unregisterParticipant(EventListener entity) {
        return this.unregisterParticipant(entity.getID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ADDRESST unregisterParticipant(UUID entityID) {
        Object object = this.mutex();
        synchronized (object) {
            this.removeListener((Serializable)this.participants.get(entityID));
            return (ADDRESST)((Serializable)this.participants.remove(entityID));
        }
    }

    public ADDRESST getAddress(EventListener entity) {
        return this.getAddress(entity.getID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ADDRESST getAddress(UUID id) {
        Object object = this.mutex();
        synchronized (object) {
            return (ADDRESST)((Serializable)this.participants.get(id));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SynchronizedCollection<ADDRESST> getParticipantAddresses() {
        Object mutex;
        Object object = mutex = this.mutex();
        synchronized (object) {
            return Collections3.synchronizedCollection(this.participants.values(), mutex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SynchronizedSet<UUID> getParticipantIDs() {
        Object mutex;
        Object object = mutex = this.mutex();
        synchronized (object) {
            return Collections3.synchronizedSet(this.participants.keySet(), mutex);
        }
    }
}

