/*
 * Decompiled with CFR 0.152.
 */
package io.janusproject.kernel.repository;

import io.sarl.lang.core.EventListener;
import io.sarl.lang.util.SynchronizedCollection;
import io.sarl.lang.util.SynchronizedSet;
import io.sarl.util.Collections3;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public abstract class ParticipantRepository<ADDRESST extends Serializable> {
    private final Map<ADDRESST, EventListener> listeners = new TreeMap<ADDRESST, EventListener>();

    protected ParticipantRepository() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int listenerCount() {
        Object object = this.mutex();
        synchronized (object) {
            return this.listeners.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isListenerEmpty() {
        Object object = this.mutex();
        synchronized (object) {
            return this.listeners.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean containsAddress(ADDRESST key) {
        Object object = this.mutex();
        synchronized (object) {
            return this.listeners.containsKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean containsListener(EventListener value) {
        Object object = this.mutex();
        synchronized (object) {
            return this.listeners.containsValue(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected EventListener getListener(ADDRESST key) {
        Object object = this.mutex();
        synchronized (object) {
            return this.listeners.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected EventListener addListener(ADDRESST key, EventListener value) {
        Object object = this.mutex();
        synchronized (object) {
            return this.listeners.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected EventListener removeListener(ADDRESST key) {
        Object object = this.mutex();
        synchronized (object) {
            return this.listeners.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearListeners() {
        Object object = this.mutex();
        synchronized (object) {
            this.listeners.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SynchronizedSet<ADDRESST> getAdresses() {
        Object mutex;
        Object object = mutex = this.mutex();
        synchronized (object) {
            return Collections3.synchronizedSet(this.listeners.keySet(), mutex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SynchronizedCollection<EventListener> getListeners() {
        Object mutex;
        Object object = mutex = this.mutex();
        synchronized (object) {
            return Collections3.synchronizedCollection(this.listeners.values(), mutex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<Map.Entry<ADDRESST, EventListener>> listenersEntrySet() {
        Object mutex;
        Object object = mutex = this.mutex();
        synchronized (object) {
            return Collections3.synchronizedSet(this.listeners.entrySet(), mutex);
        }
    }

    public abstract Object mutex();
}

