/*
 * Decompiled with CFR 0.152.
 */
package io.janusproject.kernel.repository;

import io.janusproject.kernel.repository.ParticipantRepository;
import io.janusproject.services.distributeddata.DMultiMap;
import io.janusproject.services.distributeddata.DistributedDataStructureService;
import io.sarl.lang.core.EventListener;
import io.sarl.lang.util.SynchronizedCollection;
import io.sarl.lang.util.SynchronizedSet;
import io.sarl.util.Collections3;
import java.io.Serializable;
import java.util.UUID;

public final class MultipleAddressParticipantRepository<ADDRESST extends Serializable>
extends ParticipantRepository<ADDRESST> {
    private final DMultiMap<UUID, ADDRESST> participants;
    private final String distributedParticipantMapName;

    public MultipleAddressParticipantRepository(String distributedParticipantMapName, DistributedDataStructureService repositoryImplFactory) {
        this.distributedParticipantMapName = distributedParticipantMapName;
        this.participants = repositoryImplFactory.getMultiMap(this.distributedParticipantMapName, null);
    }

    @Override
    public Object mutex() {
        return this.participants;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ADDRESST registerParticipant(ADDRESST address, EventListener entity) {
        Object object = this.mutex();
        synchronized (object) {
            this.addListener(address, entity);
            this.participants.put(entity.getID(), address);
        }
        return address;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ADDRESST unregisterParticipant(ADDRESST address, EventListener entity) {
        Object object = this.mutex();
        synchronized (object) {
            this.removeListener(address);
            this.participants.remove(entity.getID(), address);
        }
        return address;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SynchronizedCollection<ADDRESST> getAddresses(UUID participant) {
        Object mutex;
        Object object = mutex = this.mutex();
        synchronized (object) {
            return Collections3.synchronizedCollection(this.participants.get(participant), mutex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SynchronizedCollection<ADDRESST> getParticipantAddresses() {
        Object mutex;
        Object object = mutex = this.mutex();
        synchronized (object) {
            return Collections3.synchronizedCollection(this.participants.values(), mutex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SynchronizedSet<UUID> getParticipantIDs() {
        Object mutex;
        Object object = mutex = this.mutex();
        synchronized (object) {
            return Collections3.synchronizedSet(this.participants.keySet(), mutex);
        }
    }
}

