/*
 * Decompiled with CFR 0.152.
 */
package io.janusproject.kernel.bic;

import io.janusproject.kernel.bic.BuiltinSkill;
import io.sarl.core.Time;
import io.sarl.lang.core.Agent;
import io.sarl.lang.scoping.batch.SARLTimeExtensions;
import java.util.concurrent.TimeUnit;

public class TimeSkill
extends BuiltinSkill
implements Time {
    private static int installationOrder = -1;

    TimeSkill(Agent agent) {
        super(agent);
    }

    @Override
    public int getInstallationOrder() {
        if (installationOrder < 0) {
            installationOrder = TimeSkill.installationOrder(this);
        }
        return installationOrder;
    }

    @Override
    public double getTime(TimeUnit timeUnit) {
        double currentTime = System.currentTimeMillis();
        if (timeUnit == null || timeUnit == TimeUnit.SECONDS) {
            return (double)System.currentTimeMillis() / 1000.0;
        }
        if (timeUnit == TimeUnit.MILLISECONDS) {
            return currentTime;
        }
        return SARLTimeExtensions.convertFromTo(currentTime, TimeUnit.MILLISECONDS, timeUnit);
    }

    @Override
    public double getTime() {
        return (double)System.currentTimeMillis() / 1000.0;
    }

    @Override
    public double getOSTimeFactor() {
        return 1.0;
    }
}

