/*
 * Decompiled with CFR 0.152.
 */
package io.janusproject.kernel.bic;

import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import io.janusproject.kernel.bic.AgentTraitData;
import io.janusproject.kernel.bic.BuiltinSkill;
import io.janusproject.kernel.bic.Messages;
import io.janusproject.services.executor.EarlyExitException;
import io.janusproject.services.executor.ExecutorService;
import io.janusproject.services.executor.JanusRunnable;
import io.sarl.core.AgentTask;
import io.sarl.core.Logging;
import io.sarl.core.Schedules;
import io.sarl.lang.core.Agent;
import io.sarl.lang.core.AgentTrait;
import io.sarl.lang.core.Behavior;
import io.sarl.lang.core.Capacities;
import io.sarl.lang.core.SREutils;
import io.sarl.lang.core.Skill;
import io.sarl.lang.util.ClearableReference;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class SchedulesSkill
extends BuiltinSkill
implements Schedules {
    private static int installationOrder = -1;
    @Inject
    private ExecutorService executorService;
    private final Map<String, TaskDescription> tasks = new TreeMap<String, TaskDescription>();
    private ClearableReference<Skill> skillBufferLogging;

    SchedulesSkill(Agent agent) {
        super(agent);
    }

    protected final Logging getLoggingSkill() {
        if (this.skillBufferLogging == null || this.skillBufferLogging.get() == null) {
            this.skillBufferLogging = this.$getSkill(Logging.class);
        }
        return this.$castSkill(Logging.class, this.skillBufferLogging);
    }

    protected final Object getTaskListMutex() {
        return this.tasks;
    }

    @Override
    public int getInstallationOrder() {
        if (installationOrder < 0) {
            installationOrder = SchedulesSkill.installationOrder(this);
        }
        return installationOrder;
    }

    @Override
    protected String attributesToString() {
        return String.valueOf(super.attributesToString()) + ", tasks = " + this.tasks;
    }

    private void finishTask(AgentTask task, boolean updateSkillReferences, boolean updateAgentTraitReferences) {
        AgentTraitData data;
        Object initiator;
        assert (task != null);
        if (updateSkillReferences) {
            this.tasks.remove(task.getName());
        }
        if (updateAgentTraitReferences && (initiator = task.getInitiator()) instanceof AgentTrait && (data = SREutils.getSreSpecificData((AgentTrait)initiator, AgentTraitData.class)) != null) {
            data.removeTask(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<String> getActiveTasks() {
        Object object = this.getTaskListMutex();
        synchronized (object) {
            return Lists.newArrayList(this.tasks.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<Future<?>> getActiveFutures() {
        Object object = this.getTaskListMutex();
        synchronized (object) {
            return Lists.newArrayList(Iterables.transform(this.tasks.values(), it -> it.getFuture()));
        }
    }

    synchronized void unregisterTasksForBehavior(Behavior behavior) {
        AgentTraitData data = SREutils.getSreSpecificData(behavior, AgentTraitData.class);
        if (data != null) {
            Iterable<AgentTask> iterable = data.resetTaskList();
            for (AgentTask taskToCancel : iterable) {
                this.cancel(taskToCancel, true, false);
            }
        }
    }

    private void cancelAllRunningTasks() {
        for (Map.Entry<String, TaskDescription> taskDescription : this.tasks.entrySet()) {
            AgentTask task;
            TaskDescription pair = taskDescription.getValue();
            if (pair == null) continue;
            Future<?> future = pair.getFuture();
            if (future != null) {
                future.cancel(true);
            }
            if ((task = pair.getTask()) == null) continue;
            this.finishTask(task, false, true);
        }
        this.tasks.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void uninstall(Skill.UninstallationStage stage) {
        if (stage == Skill.UninstallationStage.PRE_DESTROY_EVENT) {
            Object object = this.getTaskListMutex();
            synchronized (object) {
                this.cancelAllRunningTasks();
            }
        }
        Object object = this.getTaskListMutex();
        synchronized (object) {
            this.cancelAllRunningTasks();
        }
    }

    @Override
    public AgentTask in(long delay, Procedures.Procedure1<? super Agent> procedure) {
        return this.in(Schedules.$DEFAULT_VALUE$IN_0, delay, procedure);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AgentTask in(AgentTask task, long delay, Procedures.Procedure1<? super Agent> procedure) {
        TaskDescription pair;
        Object object = this.getTaskListMutex();
        synchronized (object) {
            pair = this.preRunTask(task, procedure);
        }
        AgentTask runnableTask = pair != null ? pair.getTask() : task;
        ScheduledFuture<?> sf = this.executorService.schedule(new AgentTaskRunner(runnableTask, false), delay, TimeUnit.MILLISECONDS);
        Object object2 = this.getTaskListMutex();
        synchronized (object2) {
            pair = this.postRunTask(pair, task, sf);
        }
        return pair.getTask();
    }

    private TaskDescription preRunTask(AgentTask task, Procedures.Procedure1<? super Agent> procedure) {
        AgentTask rtask;
        TaskDescription pair;
        if (task == null) {
            pair = this.createTaskIfNecessary(null);
            rtask = pair.getTask();
        } else {
            rtask = task;
            pair = this.tasks.get(task.getName());
            if (pair != null) {
                pair.setTask(rtask);
            }
        }
        rtask.setProcedure(procedure);
        return pair;
    }

    private TaskDescription postRunTask(TaskDescription description, AgentTask task, Future<?> future) {
        TaskDescription pair;
        if (description == null) {
            pair = new TaskDescription(task, future);
            this.tasks.put(task.getName(), pair);
        } else {
            pair = description;
            pair.setFuture(future);
        }
        return pair;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TaskDescription createTaskIfNecessary(String name) {
        String realName;
        TaskDescription pair = null;
        if (Strings.isNullOrEmpty(name)) {
            realName = "task-" + UUID.randomUUID().toString();
        } else {
            realName = name;
            Object object = this.getTaskListMutex();
            synchronized (object) {
                pair = this.tasks.get(realName);
            }
        }
        if (pair == null) {
            AgentTrait caller = Capacities.getCaller();
            AgentTask task = new AgentTask(caller);
            task.setName(realName);
            task.setGuard(AgentTask.TRUE_GUARD);
            pair = new TaskDescription(task);
            Object object = this.getTaskListMutex();
            synchronized (object) {
                this.tasks.put(realName, pair);
                if (caller != null) {
                    AgentTraitData data = SREutils.getSreSpecificData(caller, AgentTraitData.class);
                    if (data == null) {
                        data = new AgentTraitData();
                        SREutils.setSreSpecificData(caller, data);
                    }
                    data.addTask(task);
                }
            }
        }
        return pair;
    }

    @Override
    public AgentTask task(String name) {
        return this.createTaskIfNecessary(name).getTask();
    }

    @Override
    public final boolean cancel(AgentTask task) {
        return this.cancel(task, true, true);
    }

    @Override
    public final boolean cancel(AgentTask task, boolean mayInterruptIfRunning) {
        return this.cancel(task, mayInterruptIfRunning, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean cancel(AgentTask task, boolean mayInterruptIfRunning, boolean updateAgentTraitReferences) {
        if (task != null) {
            String name = task.getName();
            Object object = this.getTaskListMutex();
            synchronized (object) {
                block5: {
                    Future<?> future;
                    TaskDescription pair = this.tasks.get(name);
                    if (pair == null || (future = pair.getFuture()) == null || future.isDone() || future.isCancelled() || !future.cancel(mayInterruptIfRunning)) break block5;
                    this.finishTask(task, true, updateAgentTraitReferences);
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean isCanceled(AgentTask task) {
        String name;
        Future<?> future;
        if (task != null && (future = this.getActiveFuture(name = task.getName())) != null) {
            return future.isCancelled();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Future<?> getActiveFuture(String taskName) {
        Object object = this.getTaskListMutex();
        synchronized (object) {
            TaskDescription pair = this.tasks.get(taskName);
            if (pair != null) {
                return pair.getFuture();
            }
        }
        return null;
    }

    @Override
    public AgentTask every(long period, Procedures.Procedure1<? super Agent> procedure) {
        return this.every(Schedules.$DEFAULT_VALUE$EVERY_0, period, procedure);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AgentTask every(AgentTask task, long period, Procedures.Procedure1<? super Agent> procedure) {
        TaskDescription description;
        Object object = this.getTaskListMutex();
        synchronized (object) {
            description = this.preRunTask(task, procedure);
        }
        AgentTask runnableTask = description != null ? description.getTask() : task;
        ScheduledFuture<?> sf = this.executorService.scheduleAtFixedRate(new AgentTaskRunner(runnableTask, true), 0L, period, TimeUnit.MILLISECONDS);
        Object object2 = this.getTaskListMutex();
        synchronized (object2) {
            description = this.postRunTask(description, task, sf);
        }
        return description.getTask();
    }

    @Override
    public AgentTask atFixedDelay(long delay, Procedures.Procedure1<? super Agent> procedure) {
        return this.atFixedDelay(Schedules.$DEFAULT_VALUE$ATFIXEDDELAY_0, delay, procedure);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AgentTask atFixedDelay(AgentTask task, long delay, Procedures.Procedure1<? super Agent> procedure) {
        TaskDescription description;
        Object object = this.getTaskListMutex();
        synchronized (object) {
            description = this.preRunTask(task, procedure);
        }
        AgentTask runnableTask = description != null ? description.getTask() : task;
        Future<?> future = delay <= 0L ? this.executorService.submit(new AgentInfiniteLoopTask(runnableTask)) : this.executorService.scheduleWithFixedDelay(new AgentTaskRunner(runnableTask, true), 0L, delay, TimeUnit.MILLISECONDS);
        Object object2 = this.getTaskListMutex();
        synchronized (object2) {
            description = this.postRunTask(description, task, future);
        }
        return description.getTask();
    }

    @Override
    public AgentTask execute(Procedures.Procedure1<? super Agent> procedure) {
        return this.execute(Schedules.$DEFAULT_VALUE$EXECUTE_0, procedure);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized AgentTask execute(AgentTask task, Procedures.Procedure1<? super Agent> procedure) {
        TaskDescription description;
        Object object = this.getTaskListMutex();
        synchronized (object) {
            description = this.preRunTask(task, procedure);
        }
        AgentTask runnableTask = description != null ? description.getTask() : task;
        Future<?> future = this.executorService.submit(new AgentTaskRunner(runnableTask, false));
        Object object2 = this.getTaskListMutex();
        synchronized (object2) {
            description = this.postRunTask(description, task, future);
        }
        return description.getTask();
    }

    private class AgentInfiniteLoopTask
    extends JanusRunnable {
        private WeakReference<AgentTask> agentTaskRef;

        AgentInfiniteLoopTask(AgentTask task) {
            this.agentTaskRef = new WeakReference<AgentTask>(task);
        }

        private boolean canRun() {
            AgentTask task = (AgentTask)this.agentTaskRef.get();
            if (task != null) {
                Future<?> future = SchedulesSkill.this.getActiveFuture(task.getName());
                return future != null && !future.isDone() && !future.isCancelled();
            }
            return false;
        }

        private Functions.Function1<? super Agent, ? extends Boolean> getGuard() {
            AgentTask task = (AgentTask)this.agentTaskRef.get();
            if (task != null) {
                return task.getGuard();
            }
            return null;
        }

        private Procedures.Procedure1<? super Agent> getProcedure() {
            AgentTask task = (AgentTask)this.agentTaskRef.get();
            if (task != null) {
                return task.getProcedure();
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block24: {
                AgentTask task;
                try {
                    Agent owner = SchedulesSkill.this.getOwner();
                    while (this.canRun()) {
                        Functions.Function1<? super Agent, ? extends Boolean> guard = this.getGuard();
                        if (guard == null || guard.apply(owner).booleanValue()) {
                            Procedures.Procedure1<? super Agent> procedure = this.getProcedure();
                            if (procedure != null) {
                                procedure.apply(owner);
                            }
                            Thread.yield();
                            continue;
                        }
                        break;
                    }
                }
                catch (EarlyExitException earlyExitException) {
                    AgentTask task2 = (AgentTask)this.agentTaskRef.get();
                    if (task2 == null) break block24;
                    Object object = SchedulesSkill.this.getTaskListMutex();
                    synchronized (object) {
                        SchedulesSkill.this.finishTask(task2, true, true);
                        break block24;
                    }
                }
                catch (Throwable ex) {
                    try {
                        SchedulesSkill.this.getLoggingSkill().error((Object)Messages.SchedulesSkill_1, ex, this.toString(), ex.getLocalizedMessage());
                    }
                    catch (Throwable throwable) {
                        AgentTask task3 = (AgentTask)this.agentTaskRef.get();
                        if (task3 != null) {
                            Object object = SchedulesSkill.this.getTaskListMutex();
                            synchronized (object) {
                                SchedulesSkill.this.finishTask(task3, true, true);
                            }
                        }
                        throw throwable;
                    }
                    AgentTask task4 = (AgentTask)this.agentTaskRef.get();
                    if (task4 == null) break block24;
                    Object object = SchedulesSkill.this.getTaskListMutex();
                    synchronized (object) {
                        SchedulesSkill.this.finishTask(task4, true, true);
                        break block24;
                    }
                }
                if ((task = (AgentTask)this.agentTaskRef.get()) != null) {
                    Object object = SchedulesSkill.this.getTaskListMutex();
                    synchronized (object) {
                        SchedulesSkill.this.finishTask(task, true, true);
                    }
                }
            }
        }

        @Override
        public String toString() {
            return MoreObjects.toStringHelper(this).add("name", ((AgentTask)this.agentTaskRef.get()).getName()).add("agent", SchedulesSkill.this.getOwner().getID()).toString();
        }
    }

    private class AgentTaskRunner
    extends JanusRunnable {
        private final WeakReference<AgentTask> agentTaskRef;
        private WeakReference<Future<?>> future;
        private final boolean isPeriodic;

        AgentTaskRunner(AgentTask task, boolean isPeriodic) {
            assert (task != null);
            this.agentTaskRef = new WeakReference<AgentTask>(task);
            this.isPeriodic = isPeriodic;
        }

        void setFuture(Future<?> future) {
            this.future = future == null ? null : new WeakReference(future);
        }

        private Future<?> getFuture() {
            WeakReference<Future<?>> safeFutureReference = this.future;
            return safeFutureReference == null ? null : (Future)safeFutureReference.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block24: {
                AgentTask task = (AgentTask)this.agentTaskRef.get();
                if (task == null) {
                    throw new RuntimeException(Messages.SchedulesSkill_0);
                }
                Future<?> future = this.getFuture();
                if (future != null && (future.isDone() || future.isCancelled())) {
                    this.setFuture(null);
                    return;
                }
                boolean mustBeCanceled = false;
                try {
                    Agent owner = SchedulesSkill.this.getOwner();
                    Functions.Function1<? super Agent, ? extends Boolean> guard = task.getGuard();
                    if (guard == null || guard.apply(owner).booleanValue()) {
                        Procedures.Procedure1<? super Agent> procedure = task.getProcedure();
                        if (procedure != null) {
                            procedure.apply(owner);
                        }
                    } else {
                        mustBeCanceled = true;
                    }
                }
                catch (EarlyExitException earlyExitException) {
                    if (!mustBeCanceled && this.isPeriodic) break block24;
                    Object object = SchedulesSkill.this.getTaskListMutex();
                    synchronized (object) {
                        SchedulesSkill.this.finishTask(task, true, true);
                        break block24;
                    }
                }
                catch (Throwable ex) {
                    Object object;
                    try {
                        SchedulesSkill.this.getLoggingSkill().error((Object)Messages.SchedulesSkill_1, ex, this.toString(), ex.getLocalizedMessage());
                        mustBeCanceled = true;
                        if (!mustBeCanceled && this.isPeriodic) break block24;
                        object = SchedulesSkill.this.getTaskListMutex();
                    }
                    catch (Throwable throwable) {
                        if (mustBeCanceled || !this.isPeriodic) {
                            Object object2 = SchedulesSkill.this.getTaskListMutex();
                            synchronized (object2) {
                                SchedulesSkill.this.finishTask(task, true, true);
                            }
                        }
                        throw throwable;
                    }
                    synchronized (object) {
                        SchedulesSkill.this.finishTask(task, true, true);
                        break block24;
                    }
                }
                if (!mustBeCanceled && this.isPeriodic) break block24;
                Object object = SchedulesSkill.this.getTaskListMutex();
                synchronized (object) {
                    SchedulesSkill.this.finishTask(task, true, true);
                }
            }
        }

        @Override
        public String toString() {
            return MoreObjects.toStringHelper(this).add("name", ((AgentTask)this.agentTaskRef.get()).getName()).add("agent", SchedulesSkill.this.getOwner().getID()).toString();
        }
    }

    private static class TaskDescription {
        private AgentTask task;
        private Future<?> future;

        TaskDescription(AgentTask task) {
            this.task = task;
        }

        TaskDescription(AgentTask task, Future<?> future) {
            this.task = task;
            this.future = future;
        }

        public String toString() {
            return Objects.toString(this.task);
        }

        public AgentTask getTask() {
            return this.task;
        }

        public void setTask(AgentTask task) {
            this.task = task;
        }

        public Future<?> getFuture() {
            return this.future;
        }

        public void setFuture(Future<?> future) {
            this.future = future;
        }
    }
}

