/*
 * Decompiled with CFR 0.152.
 */
package io.janusproject.kernel.bic;

import com.google.common.base.Throwables;
import com.google.inject.Inject;
import io.janusproject.kernel.bic.BuiltinSkill;
import io.janusproject.kernel.bic.Messages;
import io.janusproject.services.logging.LogService;
import io.janusproject.util.LoggerCreator;
import io.sarl.core.Logging;
import io.sarl.lang.core.Agent;
import java.text.MessageFormat;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class LoggingSkill
extends BuiltinSkill
implements Logging {
    private static int installationOrder = -1;
    @Inject
    private LogService logService;
    private Logger logger;

    LoggingSkill(Agent agent) {
        super(agent);
    }

    @Override
    public int getInstallationOrder() {
        if (installationOrder < 0) {
            installationOrder = LoggingSkill.installationOrder(this);
        }
        return installationOrder;
    }

    public Logger getLogger() {
        return this.logger;
    }

    @Override
    protected void install() {
        UUID agentId = this.getOwner().getID();
        String loggerName = MessageFormat.format(Messages.LoggingSkill_0, agentId);
        this.logger = LoggerCreator.createLogger(loggerName, this.logService.getLogger());
    }

    @Override
    public void setLoggingName(String name) {
        String loggingName = name;
        if (loggingName == null || loggingName.isEmpty()) {
            loggingName = MessageFormat.format(Messages.LoggingSkill_0, this.getOwner().getID());
        }
        Level level = this.logger.getLevel();
        this.logger = LoggerCreator.createLogger(loggingName, this.logService.getLogger());
        this.logger.setLevel(level);
    }

    @Override
    public void println(Object message) {
        this.info(message, new Object[0]);
    }

    @Override
    public void error(Object message, Throwable exception, Object ... parameters) {
        if (this.logger.isLoggable(Level.SEVERE) && message != null) {
            String loggeableMessage = message.toString();
            if (exception != null) {
                LogRecord lr = new LogRecord(Level.SEVERE, loggeableMessage);
                lr.setParameters(parameters);
                lr.setThrown(Throwables.getRootCause(exception));
                this.logger.log(lr);
            } else {
                this.logger.log(Level.SEVERE, loggeableMessage, parameters);
            }
        }
    }

    @Override
    public void error(Object message, Object ... parameters) {
        if (this.logger.isLoggable(Level.SEVERE) && message != null) {
            String loggeableMessage = message.toString();
            this.logger.log(Level.SEVERE, loggeableMessage, parameters);
        }
    }

    @Override
    public void warning(Object message, Throwable exception, Object ... parameters) {
        String loggeableMessage;
        if (this.logger.isLoggable(Level.WARNING) && message != null && !(loggeableMessage = message.toString()).isEmpty()) {
            if (exception != null) {
                LogRecord lr = new LogRecord(Level.WARNING, loggeableMessage);
                lr.setParameters(parameters);
                lr.setThrown(exception);
                this.logger.log(lr);
            } else {
                this.logger.log(Level.WARNING, loggeableMessage, parameters);
            }
        }
    }

    @Override
    public void warning(Object message, Object ... parameters) {
        String loggeableMessage;
        if (this.logger.isLoggable(Level.WARNING) && message != null && !(loggeableMessage = message.toString()).isEmpty()) {
            this.logger.log(Level.WARNING, loggeableMessage, parameters);
        }
    }

    @Override
    public void info(Object message, Object ... parameters) {
        String loggeableMessage;
        if (this.logger.isLoggable(Level.INFO) && message != null && !(loggeableMessage = message.toString()).isEmpty()) {
            this.logger.log(Level.INFO, loggeableMessage, parameters);
        }
    }

    @Override
    public void debug(Object message, Object ... parameters) {
        String loggeableMessage;
        if (this.logger.isLoggable(Level.CONFIG) && message != null && !(loggeableMessage = message.toString()).isEmpty()) {
            this.logger.log(Level.CONFIG, loggeableMessage, parameters);
        }
    }

    @Override
    public boolean isErrorLogEnabled() {
        return this.logger.isLoggable(Level.SEVERE);
    }

    @Override
    public boolean isWarningLogEnabled() {
        return this.logger.isLoggable(Level.WARNING);
    }

    @Override
    public boolean isInfoLogEnabled() {
        return this.logger.isLoggable(Level.INFO);
    }

    @Override
    public boolean isDebugLogEnabled() {
        return this.logger.isLoggable(Level.CONFIG);
    }

    @Override
    public int getLogLevel() {
        return LoggerCreator.toInt(this.logger.getLevel());
    }

    @Override
    public void setLogLevel(int level) {
        this.logger.setLevel(LoggerCreator.fromInt(level));
    }
}

