/*
 * Decompiled with CFR 0.152.
 */
package io.janusproject.kernel.bic;

import com.google.common.base.Throwables;
import com.google.common.collect.Queues;
import com.google.inject.Inject;
import io.janusproject.kernel.bic.AsynchronousAgentKillingEvent;
import io.janusproject.kernel.bic.BuiltinSkill;
import io.janusproject.kernel.bic.InternalEventBusCapacity;
import io.janusproject.kernel.bic.Messages;
import io.janusproject.kernel.bic.internaleventdispatching.AgentInternalEventsDispatcher;
import io.janusproject.services.logging.LogService;
import io.janusproject.services.spawn.SpawnService;
import io.sarl.core.AgentSpawned;
import io.sarl.core.Destroy;
import io.sarl.core.Initialize;
import io.sarl.core.Logging;
import io.sarl.lang.core.Address;
import io.sarl.lang.core.Agent;
import io.sarl.lang.core.Event;
import io.sarl.lang.core.EventListener;
import io.sarl.lang.core.Skill;
import io.sarl.lang.util.ClearableReference;
import java.util.Collection;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.eclipse.xtext.xbase.lib.Functions;

public class InternalEventBusSkill
extends BuiltinSkill
implements InternalEventBusCapacity {
    private static int installationOrder = -1;
    private final AtomicReference<InternalEventBusCapacity.OwnerState> ownerState = new AtomicReference<InternalEventBusCapacity.OwnerState>(InternalEventBusCapacity.OwnerState.UNSTARTED);
    private final AgentEventListener agentAsEventListener = new AgentEventListener();
    @Inject
    private AgentInternalEventsDispatcher eventDispatcher;
    @Inject
    private LogService logger;
    @Inject
    private SpawnService spawnService;
    private final Address agentAddressInInnerDefaultSpace;
    private ClearableReference<Skill> skillBufferLogging;

    InternalEventBusSkill(Agent agent, Address addressInInnerDefaultSpace) {
        super(agent);
        this.agentAddressInInnerDefaultSpace = addressInInnerDefaultSpace;
    }

    protected final Logging getLoggingSkill() {
        if (this.skillBufferLogging == null || this.skillBufferLogging.get() == null) {
            this.skillBufferLogging = this.$getSkill(Logging.class);
        }
        return this.$castSkill(Logging.class, this.skillBufferLogging);
    }

    @Override
    public int getInstallationOrder() {
        if (installationOrder < 0) {
            installationOrder = InternalEventBusSkill.installationOrder(this);
        }
        return installationOrder;
    }

    @Override
    protected String attributesToString() {
        return String.valueOf(super.attributesToString()) + ", state = " + (Object)((Object)this.getOwnerState()) + ", addressInDefaultspace = " + this.agentAddressInInnerDefaultSpace;
    }

    @Override
    public InternalEventBusCapacity.OwnerState getOwnerState() {
        return this.ownerState.get();
    }

    void setOwnerState(InternalEventBusCapacity.OwnerState state) {
        assert (state != null);
        this.ownerState.set(state);
    }

    @Override
    public Address getInnerDefaultSpaceAddress() {
        return this.agentAddressInInnerDefaultSpace;
    }

    @Override
    protected void install() {
        this.eventDispatcher.register(this.getOwner(), null, null);
    }

    @Override
    protected void uninstall(Skill.UninstallationStage stage) {
        if (stage == Skill.UninstallationStage.POST_DESTROY_EVENT) {
            Destroy event = new Destroy();
            event.setSource(this.getInnerDefaultSpaceAddress());
            this.eventDispatcher.unregisterAll(subscriber -> {
                if (subscriber != this.getOwner()) {
                    this.eventDispatcher.immediateDispatchTo(subscriber, event);
                }
            });
        }
    }

    @Override
    @Deprecated
    public void registerEventListener(Object listener) {
        this.registerEventListener(listener, true, null);
    }

    @Override
    public void registerEventListener(Object listener, boolean fireInitializeEvent, Functions.Function1<? super Event, ? extends Boolean> filter) {
        if (fireInitializeEvent) {
            InternalEventBusCapacity.OwnerState state = this.getOwnerState();
            if (state == InternalEventBusCapacity.OwnerState.INITIALIZING || state == InternalEventBusCapacity.OwnerState.ALIVE) {
                this.eventDispatcher.register(listener, filter, subscriber -> {
                    Initialize event = new Initialize(this.getOwner().getID(), new Object[0]);
                    event.setSource(this.getInnerDefaultSpaceAddress());
                    this.eventDispatcher.immediateDispatchTo(subscriber, event);
                });
            } else {
                this.eventDispatcher.register(listener, filter, null);
            }
        } else {
            this.eventDispatcher.register(listener, filter, null);
        }
    }

    @Override
    @Deprecated
    public void unregisterEventListener(Object listener) {
        this.unregisterEventListener(listener, true);
    }

    @Override
    public void unregisterEventListener(Object listener, boolean fireDestroyEvent) {
        if (fireDestroyEvent) {
            InternalEventBusCapacity.OwnerState state = this.getOwnerState();
            if (state == InternalEventBusCapacity.OwnerState.INITIALIZING || state == InternalEventBusCapacity.OwnerState.ALIVE) {
                this.eventDispatcher.unregister(listener, subscriber -> {
                    Destroy event = new Destroy();
                    event.setSource(this.getInnerDefaultSpaceAddress());
                    this.eventDispatcher.immediateDispatchTo(subscriber, event);
                });
            } else {
                this.eventDispatcher.unregister(listener, null);
            }
        } else {
            this.eventDispatcher.unregister(listener, null);
        }
    }

    private void runInitializationStage(Event event) {
        try {
            this.setOwnerState(InternalEventBusCapacity.OwnerState.INITIALIZING);
            try {
                this.eventDispatcher.immediateDispatch(event);
            }
            finally {
                this.setOwnerState(InternalEventBusCapacity.OwnerState.ALIVE);
            }
        }
        catch (Exception e) {
            Logging loggingCapacity = this.getLoggingSkill();
            if (loggingCapacity != null) {
                loggingCapacity.error((Object)Messages.InternalEventBusSkill_3, e, new Object[0]);
            } else {
                LogRecord record = new LogRecord(Level.SEVERE, Messages.InternalEventBusSkill_3);
                record.setThrown(Throwables.getRootCause(e));
                this.logger.log(record);
            }
            this.setOwnerState(InternalEventBusCapacity.OwnerState.ALIVE);
            this.agentAsEventListener.killOrMarkAsKilled();
        }
    }

    private void runDestructionStage(Event event) {
        try {
            this.setOwnerState(InternalEventBusCapacity.OwnerState.DYING);
            try {
                this.eventDispatcher.immediateDispatch(event);
            }
            finally {
                this.setOwnerState(InternalEventBusCapacity.OwnerState.DEAD);
            }
        }
        catch (Exception e) {
            Logging loggingCapacity = this.getLoggingSkill();
            if (loggingCapacity != null) {
                loggingCapacity.error((Object)Messages.InternalEventBusSkill_4, e, new Object[0]);
            }
            LogRecord record = new LogRecord(Level.SEVERE, Messages.InternalEventBusSkill_4);
            record.setThrown(Throwables.getRootCause(e));
            this.logger.log(record);
        }
    }

    @Override
    public boolean hasRegisteredEventListener(Class<?> type) {
        return this.eventDispatcher.hasRegisteredEventListener(type);
    }

    @Override
    public <T> int getRegisteredEventListeners(Class<T> type, Collection<? super T> collection) {
        return this.eventDispatcher.getRegisteredEventListeners(type, collection);
    }

    @Override
    public void selfEvent(Event event) {
        event.setSource(this.getInnerDefaultSpaceAddress());
        Class<?> eventType = event.getClass();
        if (Initialize.class.equals(eventType)) {
            this.runInitializationStage(event);
        } else if (Destroy.class.equals(eventType)) {
            this.runDestructionStage(event);
        } else if (AsynchronousAgentKillingEvent.class.equals(eventType)) {
            this.agentAsEventListener.killOrMarkAsKilled();
        } else if (this.getOwnerState().isEventHandling()) {
            this.agentAsEventListener.receiveEvent(event);
        }
    }

    @Override
    public final EventListener asEventListener() {
        return this.agentAsEventListener;
    }

    private class AgentEventListener
    implements EventListener {
        private Queue<Event> buffer = Queues.newConcurrentLinkedQueue();
        private final UUID aid;
        private final AtomicBoolean isKilled = new AtomicBoolean(false);

        AgentEventListener() {
            this.aid = InternalEventBusSkill.this.getOwner().getID();
        }

        @Override
        public UUID getID() {
            return this.aid;
        }

        @Override
        public void receiveEvent(Event event) {
            Class<?> eventType = event.getClass();
            assert (!(Initialize.class.equals(eventType) || Destroy.class.equals(eventType) || AsynchronousAgentKillingEvent.class.equals(eventType))) : "Unsupported type of event: " + event;
            if (AgentSpawned.class.equals(eventType) && ((AgentSpawned)event).agentIdentifiers.contains(this.aid)) {
                this.fireEnqueuedEvents(InternalEventBusSkill.this);
                if (this.isKilled.get()) {
                    this.killOwner(InternalEventBusSkill.this);
                    return;
                }
            }
            switch (InternalEventBusSkill.this.getOwnerState()) {
                case UNSTARTED: 
                case INITIALIZING: {
                    assert (InternalEventBusSkill.this.getOwnerState().isEventHandling());
                    this.buffer.add(event);
                    break;
                }
                case ALIVE: {
                    assert (InternalEventBusSkill.this.getOwnerState().isEventHandling());
                    this.fireEnqueuedEvents(InternalEventBusSkill.this);
                    InternalEventBusSkill.this.eventDispatcher.asyncDispatch(event);
                    break;
                }
                case DYING: 
                case DEAD: {
                    assert (!InternalEventBusSkill.this.getOwnerState().isEventHandling());
                    InternalEventBusSkill.this.logger.debug(Messages.InternalEventBusSkill_1, event);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }

        private void fireEnqueuedEvents(InternalEventBusSkill skill) {
            Queue<Event> queue = this.buffer;
            if (queue != null && !queue.isEmpty()) {
                this.buffer = null;
                for (Event evt : queue) {
                    skill.eventDispatcher.asyncDispatch(evt);
                }
            }
        }

        private boolean killOwner(InternalEventBusSkill skill) {
            return skill.spawnService.killAgent(this.aid);
        }

        boolean killOrMarkAsKilled() {
            this.isKilled.set(true);
            InternalEventBusCapacity.OwnerState state = InternalEventBusSkill.this.getOwnerState();
            assert (state != null);
            if (state == InternalEventBusCapacity.OwnerState.ALIVE) {
                return this.killOwner(InternalEventBusSkill.this);
            }
            return false;
        }
    }
}

