/*
 * Decompiled with CFR 0.152.
 */
package io.janusproject.kernel.bic;

import com.google.inject.Inject;
import io.janusproject.kernel.bic.BuiltinSkill;
import io.janusproject.kernel.bic.InternalEventBusCapacity;
import io.janusproject.services.contextspace.ContextSpaceService;
import io.sarl.core.InnerContextAccess;
import io.sarl.lang.core.Address;
import io.sarl.lang.core.Agent;
import io.sarl.lang.core.AgentContext;
import io.sarl.lang.core.Event;
import io.sarl.lang.core.EventListener;
import io.sarl.lang.core.Skill;
import io.sarl.lang.core.Space;
import io.sarl.lang.core.SpaceID;
import io.sarl.lang.util.ClearableReference;
import io.sarl.lang.util.SynchronizedSet;
import io.sarl.util.Collections3;
import io.sarl.util.OpenEventSpace;
import java.util.HashSet;
import java.util.UUID;

public class InnerContextSkill
extends BuiltinSkill
implements InnerContextAccess {
    private static int installationOrder = -1;
    private final Address agentAddressInInnerDefaultSpace;
    private ClearableReference<Skill> skillBufferInternalEventBusCapacity;
    private AgentContext innerContext;
    @Inject
    private ContextSpaceService contextService;

    InnerContextSkill(Agent agent, Address agentAddressInInnerDefaultSpace) {
        super(agent);
        this.agentAddressInInnerDefaultSpace = agentAddressInInnerDefaultSpace;
    }

    protected final InternalEventBusCapacity getInternalEventBusCapacitySkill() {
        if (this.skillBufferInternalEventBusCapacity == null || this.skillBufferInternalEventBusCapacity.get() == null) {
            this.skillBufferInternalEventBusCapacity = this.$getSkill(InternalEventBusCapacity.class);
        }
        return this.$castSkill(InternalEventBusCapacity.class, this.skillBufferInternalEventBusCapacity);
    }

    @Override
    public int getInstallationOrder() {
        if (installationOrder < 0) {
            installationOrder = InnerContextSkill.installationOrder(this);
        }
        return installationOrder;
    }

    public synchronized boolean hasInnerContext() {
        return this.innerContext != null;
    }

    synchronized void resetInnerContext() {
        this.innerContext = null;
    }

    @Override
    protected String attributesToString() {
        return String.valueOf(super.attributesToString()) + ", addressInDefaultspace = " + this.agentAddressInInnerDefaultSpace;
    }

    @Override
    protected void uninstall(Skill.UninstallationStage stage) {
        if (stage == Skill.UninstallationStage.POST_DESTROY_EVENT) {
            AgentContext context = this.innerContext;
            this.innerContext = null;
            if (context != null) {
                EventListener listener = this.getInternalEventBusCapacitySkill().asEventListener();
                ((OpenEventSpace)context.getDefaultSpace()).unregister(listener);
                this.contextService.removeContext(context);
            }
        }
    }

    @Override
    public synchronized AgentContext getInnerContext() {
        if (this.innerContext == null) {
            this.innerContext = this.contextService.createContext(this.agentAddressInInnerDefaultSpace.getSpaceId().getContextID(), this.agentAddressInInnerDefaultSpace.getSpaceId().getID());
            EventListener listener = this.getInternalEventBusCapacitySkill().asEventListener();
            OpenEventSpace defSpace = (OpenEventSpace)this.innerContext.getDefaultSpace();
            defSpace.register(listener);
        }
        return this.innerContext;
    }

    @Override
    public synchronized boolean hasMemberAgent() {
        if (this.innerContext != null) {
            SynchronizedSet<UUID> participants = this.innerContext.getDefaultSpace().getParticipants();
            assert (participants != null);
            return participants.size() > 1 || participants.size() == 1 && !participants.contains(this.getOwner().getID());
        }
        return false;
    }

    @Override
    public synchronized int getMemberAgentCount() {
        if (this.innerContext != null) {
            SynchronizedSet<UUID> participants = this.innerContext.getDefaultSpace().getParticipants();
            assert (participants != null);
            int count = participants.size();
            if (participants.contains(this.getOwner().getID())) {
                --count;
            }
            return count;
        }
        return 0;
    }

    @Override
    public synchronized SynchronizedSet<UUID> getMemberAgents() {
        if (this.innerContext != null) {
            SynchronizedSet<UUID> participants = this.innerContext.getDefaultSpace().getParticipants();
            assert (participants != null);
            HashSet<UUID> members = new HashSet<UUID>();
            UUID myId = this.getOwner().getID();
            for (UUID id : participants) {
                if (id.equals(myId)) continue;
                members.add(id);
            }
            return Collections3.synchronizedSet(members, members);
        }
        return Collections3.emptySynchronizedSet();
    }

    @Override
    public boolean isInnerDefaultSpace(Space space) {
        return this.isInnerDefaultSpace(space.getSpaceID());
    }

    @Override
    public boolean isInnerDefaultSpace(SpaceID spaceID) {
        AgentContext context = this.innerContext;
        return context != null && spaceID.equals(context.getDefaultSpace().getSpaceID());
    }

    @Override
    public boolean isInnerDefaultSpace(UUID spaceID) {
        AgentContext context = this.innerContext;
        return context != null && spaceID.equals(context.getDefaultSpace().getSpaceID().getID());
    }

    @Override
    public boolean isInInnerDefaultSpace(Event event) {
        Address adr;
        if (event != null && (adr = event.getSource()) != null) {
            return this.isInnerDefaultSpace(adr.getSpaceId());
        }
        return false;
    }
}

