/*
 * Decompiled with CFR 0.152.
 */
package io.janusproject.kernel.bic;

import com.google.common.collect.Sets;
import com.google.inject.Inject;
import io.janusproject.kernel.bic.BuiltinSkill;
import io.janusproject.kernel.bic.InternalEventBusCapacity;
import io.janusproject.kernel.bic.Messages;
import io.janusproject.services.contextspace.ContextSpaceService;
import io.sarl.core.Behaviors;
import io.sarl.core.ContextJoined;
import io.sarl.core.ContextLeft;
import io.sarl.core.ExternalContextAccess;
import io.sarl.core.MemberJoined;
import io.sarl.core.MemberLeft;
import io.sarl.lang.core.Agent;
import io.sarl.lang.core.AgentContext;
import io.sarl.lang.core.Event;
import io.sarl.lang.core.EventSpace;
import io.sarl.lang.core.Skill;
import io.sarl.lang.core.Space;
import io.sarl.lang.core.SpaceID;
import io.sarl.lang.util.ClearableReference;
import io.sarl.lang.util.SynchronizedCollection;
import io.sarl.util.Collections3;
import io.sarl.util.OpenEventSpace;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Set;
import java.util.UUID;

public class ExternalContextAccessSkill
extends BuiltinSkill
implements ExternalContextAccess {
    private static int installationOrder = -1;
    private final Set<UUID> contexts = Sets.newConcurrentHashSet();
    @Inject
    private ContextSpaceService contextRepository;
    private ClearableReference<Skill> skillBufferInternalEventBusCapacity;
    private ClearableReference<Skill> skillBufferBehaviors;

    ExternalContextAccessSkill(Agent agent) {
        super(agent);
    }

    protected final InternalEventBusCapacity getInternalEventBusCapacitySkill() {
        if (this.skillBufferInternalEventBusCapacity == null || this.skillBufferInternalEventBusCapacity.get() == null) {
            this.skillBufferInternalEventBusCapacity = this.$getSkill(InternalEventBusCapacity.class);
        }
        return this.$castSkill(InternalEventBusCapacity.class, this.skillBufferInternalEventBusCapacity);
    }

    protected final Behaviors getBehaviorsSkill() {
        if (this.skillBufferBehaviors == null || this.skillBufferBehaviors.get() == null) {
            this.skillBufferBehaviors = this.$getSkill(Behaviors.class);
        }
        return this.$castSkill(Behaviors.class, this.skillBufferBehaviors);
    }

    @Override
    public int getInstallationOrder() {
        if (installationOrder < 0) {
            installationOrder = ExternalContextAccessSkill.installationOrder(this);
        }
        return installationOrder;
    }

    @Override
    protected String attributesToString() {
        return String.valueOf(super.attributesToString()) + ", contexts = " + this.contextRepository.toString();
    }

    @Override
    protected void install() {
        AgentContext ac = this.contextRepository.getContext(this.getOwner().getParentID());
        this.join(ac.getID(), ac.getDefaultSpace().getSpaceID().getID());
    }

    @Override
    protected void uninstall(Skill.UninstallationStage stage) {
        if (stage == Skill.UninstallationStage.POST_DESTROY_EVENT) {
            for (UUID contextID : this.contexts) {
                this.leave(contextID);
            }
        }
    }

    @Override
    public SynchronizedCollection<AgentContext> getAllContexts() {
        return Collections3.synchronizedCollection(Collections.unmodifiableCollection(this.contextRepository.getContexts(this.contexts)), this.contextRepository.mutex());
    }

    @Override
    public AgentContext getContext(UUID contextID) {
        assert (contextID != null);
        if (!this.contexts.contains(contextID)) {
            throw new IllegalArgumentException(MessageFormat.format(Messages.ExternalContextAccessSkill_0, contextID));
        }
        return this.contextRepository.getContext(contextID);
    }

    @Override
    public void join(UUID futureContext, UUID futureContextDefaultSpaceID) {
        assert (futureContext != null);
        assert (futureContextDefaultSpaceID != null);
        if (this.contexts.contains(futureContext)) {
            return;
        }
        AgentContext ac = this.contextRepository.getContext(futureContext);
        assert (ac != null) : "Unknown Context";
        if (!futureContextDefaultSpaceID.equals(ac.getDefaultSpace().getSpaceID().getID())) {
            throw new IllegalArgumentException(MessageFormat.format(Messages.ExternalContextAccessSkill_1, futureContextDefaultSpaceID));
        }
        this.contexts.add(futureContext);
        ((OpenEventSpace)ac.getDefaultSpace()).register(this.getInternalEventBusCapacitySkill().asEventListener());
        this.fireContextJoined(futureContext, futureContextDefaultSpaceID);
        this.fireMemberJoined(ac);
    }

    protected final void fireContextJoined(UUID futureContext, UUID futureContextDefaultSpaceID) {
        this.getBehaviorsSkill().wake(new ContextJoined(futureContext, futureContextDefaultSpaceID));
    }

    protected final void fireMemberJoined(AgentContext newJoinedContext) {
        EventSpace defSpace = newJoinedContext.getDefaultSpace();
        defSpace.emit(new MemberJoined(defSpace.getAddress(this.getOwner().getID()), newJoinedContext.getID(), this.getOwner().getID(), this.getOwner().getClass().getName()));
    }

    @Override
    public void leave(UUID contextID) {
        assert (contextID != null);
        AgentContext ac = this.contextRepository.getContext(contextID);
        assert (ac != null) : "Unknown Context";
        if (!this.contexts.contains(contextID)) {
            return;
        }
        this.fireContextLeft(contextID);
        this.fireMemberLeft(ac);
        ((OpenEventSpace)ac.getDefaultSpace()).unregister(this.getInternalEventBusCapacitySkill().asEventListener());
        this.contexts.remove(contextID);
    }

    protected final void fireContextLeft(UUID contextID) {
        this.getBehaviorsSkill().wake(new ContextLeft(contextID));
    }

    protected final void fireMemberLeft(AgentContext leftContext) {
        EventSpace defSpace = leftContext.getDefaultSpace();
        defSpace.emit(new MemberLeft(defSpace.getAddress(this.getOwner().getID()), this.getOwner().getID(), this.getOwner().getClass().getName()));
    }

    @Override
    public boolean isInSpace(Event event, Space space) {
        return this.isInSpace(event, space.getSpaceID());
    }

    @Override
    public boolean isInSpace(Event event, SpaceID spaceID) {
        return spaceID.equals(event.getSource().getSpaceId());
    }

    @Override
    public boolean isInSpace(Event event, UUID spaceID) {
        return spaceID.equals(event.getSource().getSpaceId().getID());
    }
}

