/*
 * Decompiled with CFR 0.152.
 */
package io.janusproject.kernel.bic;

import io.janusproject.kernel.bic.BuiltinSkill;
import io.janusproject.kernel.bic.InternalEventBusCapacity;
import io.janusproject.services.spawn.SpawnService;
import io.janusproject.services.spawn.SpawnServiceListener;
import io.sarl.core.Destroy;
import io.sarl.core.Initialize;
import io.sarl.lang.core.Agent;
import io.sarl.lang.core.AgentContext;
import io.sarl.lang.core.Skill;
import io.sarl.lang.util.ClearableReference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.UUID;
import org.arakhne.afc.util.ListUtil;
import org.arakhne.afc.util.MultiCollection;

class AgentLifeCycleSupport
implements SpawnServiceListener {
    private static final Comparator<BuiltinSkill> ORDER_COMPARATOR = new OrderComparator();
    private static final Comparator<BuiltinSkill> REVERSE_ORDER_COMPARATOR = new ReverseOrderComparator();
    private static Method skillInstallationMethod;
    private static Method skillUninstallationMethod;
    private static Field agentSkillField;
    private final UUID agentID;
    private final WeakReference<SpawnService> spawnService;
    private final InternalEventBusCapacity eventBusCapacity;

    AgentLifeCycleSupport(UUID agentID, SpawnService spawnService, InternalEventBusCapacity eventBusCapacity) {
        this.agentID = agentID;
        this.spawnService = new WeakReference<SpawnService>(spawnService);
        this.eventBusCapacity = eventBusCapacity;
    }

    @Override
    public void agentSpawned(UUID spawningAgent, AgentContext parent, List<Agent> spawnedAgent, Object[] initializationParameters) {
        AgentLifeCycleSupport.installSkills(spawnedAgent.get(0));
        Initialize init = new Initialize(spawningAgent, initializationParameters);
        this.eventBusCapacity.selfEvent(init);
    }

    @Override
    public void agentDestroy(Agent agent) {
        SpawnService service = (SpawnService)this.spawnService.get();
        assert (service != null);
        service.removeSpawnServiceListener(this.agentID, this);
        Iterable<? extends Skill> skills = AgentLifeCycleSupport.getAllSkills(agent, true);
        AgentLifeCycleSupport.uninstallSkillsPreStage(skills);
        this.eventBusCapacity.selfEvent(new Destroy());
        AgentLifeCycleSupport.uninstallSkillsFinalStage(skills);
    }

    private static Iterable<? extends Skill> getAllSkills(Agent agent, boolean inReverseOrder) {
        try {
            Map skills;
            if (agentSkillField == null) {
                Field field = Agent.class.getDeclaredField("skills");
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                agentSkillField = field;
            }
            if ((skills = (Map)agentSkillField.get(agent)) != null) {
                ArrayList builtinSkills = new ArrayList();
                TreeSet<Skill> otherSkills = new TreeSet<Skill>((first, second) -> {
                    if (first == second) {
                        return 0;
                    }
                    return Integer.compare(System.identityHashCode(first), System.identityHashCode(second));
                });
                Comparator<BuiltinSkill> comparator = inReverseOrder ? REVERSE_ORDER_COMPARATOR : ORDER_COMPARATOR;
                for (ClearableReference skillReference : skills.values()) {
                    Skill skill = (Skill)skillReference.get();
                    if (skill instanceof BuiltinSkill) {
                        ListUtil.add(builtinSkills, comparator, (BuiltinSkill)skill, true, false);
                        continue;
                    }
                    if (skill == null) continue;
                    otherSkills.add(skill);
                }
                if (otherSkills.isEmpty()) {
                    return builtinSkills;
                }
                MultiCollection<Skill> allSkills = new MultiCollection<Skill>();
                if (inReverseOrder) {
                    allSkills.addCollection(otherSkills);
                    allSkills.addCollection(builtinSkills);
                } else {
                    allSkills.addCollection(builtinSkills);
                    allSkills.addCollection(otherSkills);
                }
                return allSkills;
            }
            return Collections.emptyList();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void installSkills(Agent agent) {
        try {
            if (skillInstallationMethod == null) {
                Method method = Skill.class.getDeclaredMethod("install", new Class[0]);
                if (!method.isAccessible()) {
                    method.setAccessible(true);
                }
                skillInstallationMethod = method;
            }
            for (Skill skill : AgentLifeCycleSupport.getAllSkills(agent, false)) {
                skillInstallationMethod.invoke((Object)skill, new Object[0]);
            }
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private static void uninstallSkillsPreStage(Iterable<? extends Skill> skills) {
        try {
            if (skillUninstallationMethod == null) {
                Method method = Skill.class.getDeclaredMethod("uninstall", Skill.UninstallationStage.class);
                if (!method.isAccessible()) {
                    method.setAccessible(true);
                }
                skillUninstallationMethod = method;
            }
            for (Skill skill : skills) {
                skillUninstallationMethod.invoke((Object)skill, new Object[]{Skill.UninstallationStage.PRE_DESTROY_EVENT});
            }
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private static void uninstallSkillsFinalStage(Iterable<? extends Skill> skills) {
        try {
            if (skillUninstallationMethod == null) {
                Method method = Skill.class.getDeclaredMethod("uninstall", Skill.UninstallationStage.class);
                if (!method.isAccessible()) {
                    method.setAccessible(true);
                }
                skillUninstallationMethod = method;
            }
            for (Skill skill : skills) {
                skillUninstallationMethod.invoke((Object)skill, new Object[]{Skill.UninstallationStage.POST_DESTROY_EVENT});
            }
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private static class OrderComparator
    implements Comparator<BuiltinSkill> {
        OrderComparator() {
        }

        @Override
        public int compare(BuiltinSkill outsideElement, BuiltinSkill insideElement) {
            return Integer.compare(outsideElement.getInstallationOrder(), insideElement.getInstallationOrder());
        }
    }

    private static class ReverseOrderComparator
    implements Comparator<BuiltinSkill> {
        ReverseOrderComparator() {
        }

        @Override
        public int compare(BuiltinSkill outsideElement, BuiltinSkill insideElement) {
            return Integer.compare(insideElement.getInstallationOrder(), outsideElement.getInstallationOrder());
        }
    }
}

