/*
 * Decompiled with CFR 0.152.
 */
package io.janusproject.eclipse.sre;

import com.google.common.collect.Maps;
import io.janusproject.Boot;
import io.janusproject.eclipse.buildpath.JanusClasspathContainer;
import io.janusproject.eclipse.sre.Messages;
import io.sarl.eclipse.runtime.AbstractSREInstall;
import io.sarl.eclipse.util.BundleUtil;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class JanusSREInstall
extends AbstractSREInstall {
    public static final String JANUS_SRE_ID = "io.janusproject.plugin.sre";
    private final IPath janusSREInstallPath;
    private final String location;

    public JanusSREInstall() {
        super(JANUS_SRE_ID);
        BundleUtil.IBundleDependencies dependencies = JanusClasspathContainer.getJanusPlatformClasspath();
        this.janusSREInstallPath = dependencies.getBundleBinaryPath();
        assert (this.janusSREInstallPath != null);
        this.location = this.janusSREInstallPath.toPortableString();
        this.setName("Janus SRE");
        this.setMainClass(Boot.class.getName());
        this.setClassPathEntries(dependencies.getTransitiveRuntimeClasspathEntries(true));
    }

    public String getNameNoDefault() {
        return Messages.JanusSREInstall_0;
    }

    public String getLocation() {
        return this.location;
    }

    public Map<String, String> getAvailableCommandLineOptions() {
        HashMap<String, String> options = Maps.newHashMap();
        options.put("CLI-Show-Logo", "");
        options.put("CLI-Hide-Logo", JanusSREInstall.formatCommandLineOption((String)"nologo", null));
        options.put("CLI-Show-Info", JanusSREInstall.formatCommandLineOption((String)"log", (String)"info"));
        options.put("CLI-Hide-Info", JanusSREInstall.formatCommandLineOption((String)"log", (String)"warning"));
        options.put("CLI-Default-Context-ID", JanusSREInstall.formatCommandLineOption((String)"worldid", null));
        options.put("CLI-Random-Context-ID", JanusSREInstall.formatCommandLineOption((String)"randomid", null));
        options.put("CLI-BootAgent-Context-ID", JanusSREInstall.formatCommandLineOption((String)"bootid", null));
        options.put("CLI-Offline", JanusSREInstall.formatCommandLineOption((String)"offline", null));
        options.put("CLI-Embedded", JanusSREInstall.formatCommandLineOption((String)"embedded", null));
        options.put("CLI-No-More-Option", JanusSREInstall.formatCommandLineOption(null, null));
        return Collections.unmodifiableMap(options);
    }

    public boolean isStandalone() {
        return true;
    }

    public String getSREArguments() {
        return "";
    }

    public String getJVMArguments() {
        return "";
    }

    public void getAsXML(Document document, Element element) throws IOException {
    }

    public void setFromXML(Element element) throws IOException {
    }

    protected void resolveDirtyFields(boolean forceSettings) {
    }
}

