/*
 * Decompiled with CFR 0.152.
 */
package io.janusproject;

import io.janusproject.modules.StandardJanusPlatformModule;
import io.janusproject.modules.hazelcast.HazelcastKernelLoggerFactory;
import java.util.Properties;

public final class JanusConfig {
    public static final String JANUS_DEFAULT_PLATFORM_NAME = "Janus SRE";
    public static final String HAZELCAST_LOGGER_FACTORY_NAME = "hazelcast.logging.class";
    public static final String HAZELCAST_LOGGER_FACTORY_VALUE = HazelcastKernelLoggerFactory.class.getName();
    public static final String VERBOSE_LEVEL_NAME = "janus.verbose.level";
    public static final String VERBOSE_LEVEL_VALUE = "info";
    public static final String JANUS_LOGO_SHOW_NAME = "janus.logo.show";
    public static final Boolean JANUS_LOGO_SHOW = Boolean.TRUE;
    public static final String DEFAULT_CONTEXT_ID_NAME = "janus.context.id";
    public static final String DEFAULT_CONTEXT_ID_VALUE = "2c38fb7f-f363-4f6e-877b-110b1f07cc77";
    public static final String DEFAULT_SPACE_ID_NAME = "janus.context.space.id";
    public static final String DEFAULT_SPACE_ID_VALUE = "7ba8885d-545b-445a-a0e9-b655bc15ebe0";
    public static final String RANDOM_DEFAULT_CONTEXT_ID_NAME = "janus.context.id.random";
    public static final Boolean RANDOM_DEFAULT_CONTEXT_ID_VALUE = Boolean.FALSE;
    public static final String BOOT_DEFAULT_CONTEXT_ID_NAME = "janus.context.id.boot";
    public static final Boolean BOOT_DEFAULT_CONTEXT_ID_VALUE = Boolean.FALSE;
    public static final String OFFLINE = "janus.network.offline";
    public static final String BOOT_AGENT = "janus.boot.agent";
    public static final String BOOT_AGENT_ID = "janus.boot.agent.id";
    public static final String PUB_URI = "network.pub.uri";
    public static final String MAX_NUMBER_OF_THREADS_IN_EXECUTOR_NAME = "janus.executors.threads.max";
    public static final int MAX_NUMBER_OF_THREADS_IN_EXECUTOR_VALUE = 512;
    public static final String MIN_NUMBER_OF_THREADS_IN_EXECUTOR_NAME = "janus.executors.threads.min";
    public static final int MIN_NUMBER_OF_THREADS_IN_EXECUTOR_VALUE = 16;
    public static final String THREAD_KEEP_ALIVE_DURATION_NAME = "janus.executors.threads.keepAliveDuration";
    public static final int THREAD_KEEP_ALIVE_DURATION_VALUE = 0;
    public static final String KERNEL_THREAD_TIMEOUT_NAME = "janus.executors.timeout";
    public static final int KERNEL_THREAD_TIMEOUT_VALUE = 30;
    public static final String INJECTION_MODULE_NAME = "janus.injection.module";
    public static final String INJECTION_MODULE_NAME_VALUE = StandardJanusPlatformModule.class.getName();
    public static final String KERNEL_THREAD_PURGE_DELAY_NAME = "janus.executors.purgeDelay";
    public static final int KERNEL_THREAD_PURGE_DELAY_VALUE = 30;
    public static final String JANUS_PROGRAM_NAME = "janus.programName";

    private JanusConfig() {
    }

    public static void getDefaultValues(Properties defaultValues) {
        defaultValues.put(BOOT_AGENT, "");
        defaultValues.put(BOOT_AGENT_ID, "");
        defaultValues.put(BOOT_DEFAULT_CONTEXT_ID_NAME, BOOT_DEFAULT_CONTEXT_ID_VALUE.toString());
        defaultValues.put(DEFAULT_CONTEXT_ID_NAME, DEFAULT_CONTEXT_ID_VALUE);
        defaultValues.put(DEFAULT_SPACE_ID_NAME, DEFAULT_SPACE_ID_VALUE);
        defaultValues.put(OFFLINE, Boolean.FALSE.toString());
        defaultValues.put(PUB_URI, "");
        defaultValues.put(RANDOM_DEFAULT_CONTEXT_ID_NAME, RANDOM_DEFAULT_CONTEXT_ID_VALUE.toString());
        defaultValues.put(VERBOSE_LEVEL_NAME, VERBOSE_LEVEL_VALUE);
        defaultValues.put(HAZELCAST_LOGGER_FACTORY_NAME, HAZELCAST_LOGGER_FACTORY_VALUE);
        defaultValues.put(MIN_NUMBER_OF_THREADS_IN_EXECUTOR_NAME, Integer.toString(16));
        defaultValues.put(MAX_NUMBER_OF_THREADS_IN_EXECUTOR_NAME, Integer.toString(512));
        defaultValues.put(KERNEL_THREAD_TIMEOUT_NAME, Integer.toString(30));
        defaultValues.put(KERNEL_THREAD_PURGE_DELAY_NAME, Integer.toString(30));
        defaultValues.put(INJECTION_MODULE_NAME, INJECTION_MODULE_NAME_VALUE);
        defaultValues.put(JANUS_LOGO_SHOW_NAME, JANUS_LOGO_SHOW.toString());
        defaultValues.put(JANUS_PROGRAM_NAME, "");
    }

    public static String getSystemProperty(String name) {
        return JanusConfig.getSystemProperty(name, null);
    }

    public static String getSystemProperty(String name, String defaultValue) {
        String value = System.getProperty(name, null);
        if (value != null) {
            return value;
        }
        value = System.getenv(name);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public static boolean getSystemPropertyAsBoolean(String name) {
        return JanusConfig.getSystemPropertyAsBoolean(name, false);
    }

    public static boolean getSystemPropertyAsBoolean(String name, boolean defaultValue) {
        String value = JanusConfig.getSystemProperty(name, null);
        if (value != null) {
            try {
                return Boolean.parseBoolean(value);
            }
            catch (Throwable throwable) {}
        }
        return defaultValue;
    }

    public static int getSystemPropertyAsInteger(String name) {
        return JanusConfig.getSystemPropertyAsInteger(name, 0);
    }

    public static int getSystemPropertyAsInteger(String name, int defaultValue) {
        String value = JanusConfig.getSystemProperty(name, null);
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (Throwable throwable) {}
        }
        return defaultValue;
    }

    public static float getSystemPropertyAsFloat(String name) {
        return JanusConfig.getSystemPropertyAsFloat(name, 0.0f);
    }

    public static float getSystemPropertyAsFloat(String name, float defaultValue) {
        String value = JanusConfig.getSystemProperty(name, null);
        if (value != null) {
            try {
                return Float.parseFloat(value);
            }
            catch (Throwable throwable) {}
        }
        return defaultValue;
    }

    public static <S extends Enum<S>> S getSystemPropertyAsEnum(Class<S> type, String name) {
        return JanusConfig.getSystemPropertyAsEnum(type, name, null);
    }

    public static <S extends Enum<S>> S getSystemPropertyAsEnum(Class<S> type, String name, S defaultValue) {
        String value = JanusConfig.getSystemProperty(name, null);
        if (value != null) {
            try {
                S enumeration = Enum.valueOf(type, value);
                if (enumeration != null) {
                    return enumeration;
                }
            }
            catch (Throwable throwable) {}
            try {
                int ordinal = Integer.parseInt(value);
                Enum enumeration = ((Enum[])type.getEnumConstants())[ordinal];
                if (enumeration != null) {
                    return (S)enumeration;
                }
            }
            catch (Throwable throwable) {}
        }
        return defaultValue;
    }

    public static <S> Class<? extends S> getSystemPropertyAsClass(Class<S> type, String name) {
        return JanusConfig.getSystemPropertyAsClass(type, name, null);
    }

    public static <S> Class<? extends S> getSystemPropertyAsClass(Class<S> type, String name, Class<S> defaultValue) {
        String value = JanusConfig.getSystemProperty(name, null);
        if (value != null) {
            try {
                Class<?> typeInstance = Class.forName(value);
                if (typeInstance != null) {
                    return typeInstance.asSubclass(type);
                }
            }
            catch (Throwable throwable) {}
        }
        return defaultValue;
    }

    public static Class<?> getSystemPropertyAsClass(String name) {
        return JanusConfig.getSystemPropertyAsClass(name, null);
    }

    public static Class<?> getSystemPropertyAsClass(String name, Class<?> defaultValue) {
        String value = JanusConfig.getSystemProperty(name, null);
        if (value != null) {
            try {
                Class<?> typeInstance = Class.forName(value);
                if (typeInstance != null) {
                    return typeInstance;
                }
            }
            catch (Throwable throwable) {}
        }
        return defaultValue;
    }

    public static <S> Class<? extends S> getSystemPropertyAsClass(Class<S> type, String name, String defaultValue) {
        Class<?> typeInstance;
        String value = JanusConfig.getSystemProperty(name, null);
        if (value != null) {
            try {
                typeInstance = Class.forName(value);
                if (typeInstance != null) {
                    return typeInstance.asSubclass(type);
                }
            }
            catch (Throwable throwable) {}
        }
        if (defaultValue != null) {
            try {
                typeInstance = Class.forName(defaultValue);
                if (typeInstance != null) {
                    return typeInstance.asSubclass(type);
                }
            }
            catch (Throwable throwable) {}
        }
        return null;
    }

    public static Class<?> getSystemPropertyAsClass(String name, String defaultValue) {
        Class<?> typeInstance;
        String value = JanusConfig.getSystemProperty(name, null);
        if (value != null) {
            try {
                typeInstance = Class.forName(value);
                if (typeInstance != null) {
                    return typeInstance;
                }
            }
            catch (Throwable throwable) {}
        }
        if (defaultValue != null) {
            try {
                typeInstance = Class.forName(defaultValue);
                if (typeInstance != null) {
                    return typeInstance;
                }
            }
            catch (Throwable throwable) {}
        }
        return null;
    }
}

